//
//  ItemsCollectionViewCell.swift
//  E-commerce
//
//  Created by juger on 8/26/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import Alamofire
import SwiftyJSON
import KSToastView


class ItemsCollectionViewCell: UICollectionViewCell {
    
    //MARK:- Outlets
    @IBOutlet weak var priceOfProduct: UILabel!
    @IBOutlet weak var imageOfProduct: UIImageView!
    @IBOutlet weak var nameOfProduct: UILabel!
    @IBOutlet weak var addToWishListImageView: UIImageView!
    
    //MARK:- Variables
    var subUrl : String = "\(addWishURL)"
    var productID : Int = 4
    var isAddedToWishList : Bool = false
    
    override func awakeFromNib() {
        super.awakeFromNib()
        let gesture = UITapGestureRecognizer(target: self, action: #selector(addToWishList))
        addToWishListImageView.addGestureRecognizer(gesture)
        
    }
    
    @objc func addToWishList(gesture : UITapGestureRecognizer)
    {
        if !isAddedToWishList
        {
            print(productID)
            subUrl = "\(addWishURL)"
             let isLoggedIn = UserDefaults.standard.bool(forKey: "isLoggedIn")
            if isLoggedIn {
            let params : [String : String] = ["SystemPasscode" : systemPasscode , "Product" : String(productID) , "Customer" : User.getID()]
            getDataJson(params: params)
            isAddedToWishList = !isAddedToWishList
            UIView.animate(withDuration: 1.0, animations: {
                self.addToWishListImageView.image = UIImage(named: "filledHeart")
            })
            }else {
                self.showErrorMessage(text: "you must log in to add produts to your wish list")
            }
        }else
        {
            print(productID)
            subUrl = "\(deleteWishURL)"
            let isLoggedIn = UserDefaults.standard.bool(forKey: "isLoggedIn")
            if isLoggedIn {
            let params : [String : String] = ["SystemPasscode" : systemPasscode , "Product" : String(productID) , "Customer" : String(userId!)]
            getDataJson(params: params)
            isAddedToWishList = !isAddedToWishList
            UIView.animate(withDuration: 1.0, animations: {
                self.addToWishListImageView.image = UIImage(named: "emptyHeart")
            })
            }else
            {
                self.showErrorMessage(text: "you must log in to add produts to your wish list")
            }
        }
    }
    //MARK:- Functions
    func showErrorMessage(text: String) {
        KSToastView.ks_showToast(text, duration: 3)
    }
    //get data from Web
    func getDataJson(params : [String : String]){
        let url : String = BASEURL + subUrl
        Alamofire.request(url, method: .post, parameters: params).responseJSON { response in
            if response.result.isSuccess {
                print("Success")
                var allCategoryJson : JSON = JSON(response.result.value!)
                print(allCategoryJson)
                let errorMessage : String = allCategoryJson["ErrorMessage"].stringValue
                if errorMessage == "" {
                    if self.isAddedToWishList {
                        self.showErrorMessage(text: "Added To Your Wish List")
                    } else
                    {
                        self.showErrorMessage(text: "Deleted from Your Wish List")
                    }
                }else
                {
                    self.showErrorMessage(text: errorMessage)
                }
                // let count : Int = allCategoryJson["Count"].intValue

                //print(self.dataArray[0].id)
                
            }else {
                self.showErrorMessage(text: "Faild to Add products to ur wish list, check ur connection")
                print("Failed requset api")
            }
        }
    }

}
