//
//  MyWishlistCell.swift
//  E-commerce
//
//  Created by Yahya Tabba on 10/27/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit

class MyWishlistCell: UITableViewCell {

    @IBOutlet weak var img: UIImageView!
    @IBOutlet weak var nameLbl: UILabel!
    @IBOutlet weak var priceLbl: UILabel!

    var parentVC : MyWishlistVC?
    
    var product : Product!{
        didSet{
            self.nameLbl.text = product.Name
            self.priceLbl.text = product.Price.stringValue + " " + Provider.currentLocation.symbol
            Provider.sd_setImage(self.img, urlString: product.Images.NoColor.first)
        }
    }
    
    
    @IBAction func delete(){
        self.parentVC?.removeAt(self.tag)
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

}
