//
//  ProductCell.swift
//  E-commerce
//
//  Created by Yahya Tabba on 11/1/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit
import SwiftyJSON

class ProductCell: UICollectionViewCell {

    @IBOutlet weak var img : UIImageView!
    @IBOutlet weak var nameLbl : UILabel!
    @IBOutlet weak var contentLbl : UILabel!
    @IBOutlet weak var priceLbl : UILabel!
    @IBOutlet weak var wishlistBtn : UIButton!
    var parentVC : CategoriesVC?
    
    
    var product : Product!{
        didSet{
            Provider.sd_setImage(self.img, urlString: product.Images.NoColor.first)
            self.nameLbl.text = product.Name
            self.contentLbl.text = product.SKU//product.Content
            self.priceLbl.text = product.Price.stringValue + " " + Provider.currentLocation.symbol
            
            self.wishlistBtn.isHidden = (product.IsWished == nil)
            
            if let IsWished = product.IsWished{
                let imageName = IsWished.Boolean ? "filledHeart" : "emptyHeart"
                self.wishlistBtn.setImage(UIImage(named: imageName), for: UIControl.State.normal)
            }

        }
    }
    
    var product2 : ProductHome!{
        didSet{
            Provider.sd_setImage(self.img, urlString: product2.ImageURL)
            self.nameLbl.text = product2.Name
        }
    }
    

    
    @IBAction func wishlistAction(){
        self.parentVC?.showLoading()
        if self.product.IsWished.Boolean{
            Communication.shared.deleteWish(ProductID: product.ID.stringValue) { (res) in
                self.parentVC?.hideLoading()
                self.parentVC?.products[self.tag].IsWished = JSON(false)
                self.parentVC?.collectionView.reloadItems(at: [IndexPath.init(item: self.tag, section: 1)])
            }
        }else{
            Communication.shared.addWish(ProductID: product.ID.stringValue) { (res) in
                self.parentVC?.hideLoading()
                self.parentVC?.products[self.tag].IsWished = JSON(true)
                self.parentVC?.collectionView.reloadItems(at: [IndexPath.init(item: self.tag, section: 1)])
            }
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

}
