//
//  BaseTVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 11/1/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import Foundation
import UIKit
import JGProgressHUD
import KSToastView
import XLPagerTabStrip
import Lightbox
import SideMenu

class BaseTVC: UITableViewController,UITextFieldDelegate, UITextViewDelegate, UIGestureRecognizerDelegate,UISearchBarDelegate ,IndicatorInfoProvider {
    
    var itemInfo = IndicatorInfo(title: "View")
    var imagesController = LightboxController()
    
    var hud = JGProgressHUD.init(style: JGProgressHUDStyle.dark)
    var ref = UIRefreshControl()

    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        setupViews()
        configureNavigationBar()
        
        self.view.endEditing(true)
        
        let tap = UITapGestureRecognizer(target: self, action: #selector(self.onTouch))
        tap.cancelsTouchesInView = false
        self.view.addGestureRecognizer(tap)
        
        self.ref.addTarget(self, action: #selector(getRefreshing), for: .valueChanged)
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        
        unregisterReceivers()
        registerReceivers()
        
    }
    
    override func viewDidDisappear(_ animated: Bool) {
        super.viewDidDisappear(animated)
        // unregisterReceivers()
    }
    
    //Check if the Email valid or not
    func isValidEmail(testStr:String) -> Bool {
        let emailRegEx = "[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,64}"
        
        let emailTest = NSPredicate(format:"SELF MATCHES %@", emailRegEx)
        return emailTest.evaluate(with: testStr)
    }
    
    func registerReceivers()
    {
        notific.addObserver(self, selector: #selector(self.connectionErrorNotificationReceived(_:)), name: _ConnectionErrorNotification.not, object: nil)
        
        notific.addObserver(self, selector: #selector(self.RequestErrorNotificationRecived(_:)), name: _RequestErrorNotificationReceived.not, object: nil)
    }
    
    func unregisterReceivers()
    {
        notific.removeObserver(self, name: _ConnectionErrorNotification.not, object: nil)
        
        notific.removeObserver(self, name: _RequestErrorNotificationReceived.not, object: nil)
    }
    
    
    @objc func connectionErrorNotificationReceived(_ notification: NSNotification) {
        self.hideLoading()
        
        print("connectionErrorNotificationReceived")
        if let msg = notification.object as? String{
            self.showErrorMessage(text : msg)
        }
        if let err = notification.object as? Error{
            self.showErrorMessage(text : err.localizedDescription)
        }
    }
    
    @objc func RequestErrorNotificationRecived(_ notification : NSNotification)
    {
        print("RequestErrorNotificationRecived")
        self.hideLoading()
        
        
        if let msg = notification.object as? String
        {
            self.showErrorMessage(text: msg)
        }else if let msg = notification.object as? CustomResponse{
            self.showErrorMessage(text: msg.message)
        }else if let msg = notification.object as? Error{
            self.showErrorMessage(text: msg.localizedDescription)
        }
        
        
    }
    
    
    func showErrorMessage(text: String) {
        KSToastView.ks_showToast(text, duration: 3)
    }
    
    func setupViews(){
        
    }
    
    @objc func getRefreshing(){
        self.hideLoading()
        
    }
    
    func getData(){
        self.showLoading()
        getRefreshing()
    }
    
    func configureNavigationBar() {
        
        //setup back button
        self.navigationItem.hidesBackButton = false
        let rr = UIBarButtonItem(title: "", style: UIBarButtonItem.Style.plain, target: nil, action:nil)
        self.navigationItem.backBarButtonItem = rr
    }
    
    
    @objc func navigateBack() {
        let _ = self.navigationController?.popViewController(animated: true)
    }
    
    @objc @IBAction func dissmiss(){
        self.dismiss(animated: true, completion: nil)
    }
    
    func showLoading(){
        hud.show(in: self.view, animated: false)
        hud.shadow = JGProgressHUDShadow(color: Theme.Color.primary1, offset: .zero, radius: 5.0, opacity: 0.2)
    }
    
    func hideLoading(){
        self.ref.endRefreshing()
        //        self.loadingView.hide(animated: true)
        
        self.hud.dismiss(animated : false)
    }
    
    
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        textField.resignFirstResponder()
        return true
    }
    
    
    @objc func onTouch() {
        self.view.endEditing(true)
    }
    
    func searchBarSearchButtonClicked(_ searchBar: UISearchBar) {
        searchBar.resignFirstResponder()
        
    }
    
    func indicatorInfo(for pagerTabStripController: PagerTabStripViewController) -> IndicatorInfo {
        return itemInfo
    }
    
    
    func setupSideMenu()
    {
        let storyboardNavigationController = UIStoryboard(name: "menuStoryboard", bundle: nil)
        let menuLeftNavigationController = storyboardNavigationController.instantiateViewController(withIdentifier: "menuNavigationController") as! UISideMenuNavigationController
        SideMenuManager.default.menuLeftNavigationController = menuLeftNavigationController
        SideMenuManager.default.menuAddScreenEdgePanGesturesToPresent(toView: self.view, forMenu: UIRectEdge.left)
        
        SideMenuManager.default.menuWidth = UIScreen.main.bounds.width * 2 / 3
        SideMenuManager.default.menuFadeStatusBar = false
        SideMenuManager.default.menuAnimationPresentDuration = 0.3
        SideMenuManager.default.menuAnimationDismissDuration = 0.3
        SideMenuManager.default.menuPresentMode = .menuSlideIn
    }
    
    
}
