//
//  BaseVC.swift
//  Prodygie
//
//  Created by Yahya Tabba on 4/21/18.
//  Copyright © 2018 Autotech co. All rights reserved.
//

import Foundation
import UIKit
import JGProgressHUD
import KSToastView
import XLPagerTabStrip
import Lightbox
import SideMenu

class BaseVC: UIViewController,UITextFieldDelegate, UITextViewDelegate, UIGestureRecognizerDelegate,UISearchBarDelegate ,IndicatorInfoProvider {
    
    var itemInfo = IndicatorInfo(title: "View")
    var imagesController =  ()

    
//    init(style: UITableViewStyle, itemInfo: IndicatorInfo) {
//        self.itemInfo = itemInfo
//        super.init(coder: style)
//    }
//

    var hud = JGProgressHUD.init(style: JGProgressHUDStyle.dark)
    var ref = UIRefreshControl()
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupViews()
        configureNavigationBar()
        
       // registerReceivers()
        
        self.view.endEditing(true)
        
        let tap = UITapGestureRecognizer(target: self, action: #selector(self.onTouch))
        tap.cancelsTouchesInView = false
        self.view.addGestureRecognizer(tap)
        
        self.ref.addTarget(self, action: #selector(getRefreshing), for: .valueChanged)
    }
    
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        
        unregisterReceivers()
        registerReceivers()
        
    }
    
    override func viewDidDisappear(_ animated: Bool) {
        super.viewDidDisappear(animated)
       // unregisterReceivers()
    }
    
    //Check if the Email valid or not
    func isValidEmail(testStr:String) -> Bool {
        let emailRegEx = "[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,64}"
        
        let emailTest = NSPredicate(format:"SELF MATCHES %@", emailRegEx)
        return emailTest.evaluate(with: testStr)
    }
    
    func registerReceivers()
    {
        notific.addObserver(self, selector: #selector(self.connectionErrorNotificationReceived(_:)), name: _ConnectionErrorNotification.not, object: nil)
        
        notific.addObserver(self, selector: #selector(self.RequestErrorNotificationRecived(_:)), name: _RequestErrorNotificationReceived.not, object: nil)
    }
    
    func unregisterReceivers()
    {
        notific.removeObserver(self, name: _ConnectionErrorNotification.not, object: nil)
        
        notific.removeObserver(self, name: _RequestErrorNotificationReceived.not, object: nil)
    }
    
    
    @objc func connectionErrorNotificationReceived(_ notification: NSNotification) {
        self.hideLoading()
        
        print("connectionErrorNotificationReceived")
        if let msg = notification.object as? String{
            self.showErrorMessage(text : msg)
        }
        if let err = notification.object as? Error{
            self.showErrorMessage(text : err.localizedDescription)
        }
    }
    
    @objc func RequestErrorNotificationRecived(_ notification : NSNotification)
    {
        print("RequestErrorNotificationRecived")
        self.hideLoading()
        
        if let msg = notification.object as? String
        {
            self.showErrorMessage(text: msg)
        }else if let msg = notification.object as? CustomResponse{
                self.showErrorMessage(text: msg.message)
        }else if let msg = notification.object as? Error{
            self.showErrorMessage(text: msg.localizedDescription)
        }
        
        
    }
    
    
    func showErrorMessage(text: String) {
        KSToastView.ks_showToast(text, duration: 3)
        //        self.view.makeToast(text, duration: 1, position: ToastPosition.center)
        //        self.view.makeToast(text)
        
        //        self.view.makeToast(text, duration: 1, position: CGPoint.init(x: self.view.center.x, y: self.view.frame.height - 40), style: nil)
        
        /*if text == "Not authorized"{
            User.clearMe()
            AppDelegate.setupViews()
        }*/
        
    }
    
    func setupViews(){
        
    }
    
    @objc func getRefreshing(){
        self.hideLoading()
        
    }
    
    func getData(){
        self.showLoading()
        getRefreshing()
    }
    
    func configureNavigationBar() {
        
        //setup back button
        self.navigationItem.hidesBackButton = false
        let rr = UIBarButtonItem(title: "", style: UIBarButtonItem.Style.plain, target: nil, action:nil)
        self.navigationItem.backBarButtonItem = rr
        
        
        
    }
    
    
    @objc func navigateBack() {
        let _ = self.navigationController?.popViewController(animated: true)
    }
    
    @objc @IBAction func dissmiss(){
        self.dismiss(animated: true, completion: nil)
    }
    
    func showLoading(){
        //        self.loadingView = MBProgressHUD.showAdded(to: self.view, animated: true)
        //        self.loadingView.bezelView.backgroundColor = Theme.Color.header
        //        self.loadingView.contentColor = .white
        
        hud.show(in: self.view, animated: false)
        hud.shadow = JGProgressHUDShadow(color: Theme.Color.primary1, offset: .zero, radius: 5.0, opacity: 0.2)
    }
    
    func hideLoading(){
        self.ref.endRefreshing()
        //        self.loadingView.hide(animated: true)
        
        self.hud.dismiss(animated : false)
    }
    
    
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        textField.resignFirstResponder()
        return true
    }
    
    
    @objc func onTouch() {
        self.view.endEditing(true)
    }
    
    func searchBarSearchButtonClicked(_ searchBar: UISearchBar) {
        searchBar.resignFirstResponder()
        
    }
    
    func indicatorInfo(for pagerTabStripController: PagerTabStripViewController) -> IndicatorInfo {
        return itemInfo
    }
    
    
    func setupLeftButton(){
        let menuItem = UIBarButtonItem.init(image: UIImage.init(named: "barButtonItem"), style: UIBarButtonItem.Style.plain, target: self, action: #selector(self.showSideMenu))
        menuItem.tintColor = UIColor.init("333333")
        self.navigationItem.leftBarButtonItem = menuItem
    }
    
    func setupRightBarButtons(){
        let searchItem = UIBarButtonItem.init(barButtonSystemItem: UIBarButtonItem.SystemItem.search, target: self, action: #selector(self.searchTapped))
        searchItem.tintColor = UIColor.init("333333")
        
        let cartBtn = UIButton()
        cartBtn.setImage(UIImage.init(named: "baseline_shopping_cart_black_24pt"), for: UIControl.State.normal)
        cartBtn.addTarget(self, action: #selector(self.cartTapped), for: UIControl.Event.touchUpInside)
        cartBtn.tintColor = UIColor.init("333333")
        cartBtn.sizeToFit()
        let cartItem = UIBarButtonItem.init(customView: cartBtn)
        cartItem.setBadge(text: Provider.Cart.isEmpty ? nil : "\(Provider.Cart.count)")

        self.navigationItem.rightBarButtonItems = [searchItem,cartItem]
    }
    
    
    
    func setupSideMenu(){
        let storyboardNavigationController = UIStoryboard(name: "menuStoryboard", bundle: nil)
        let menuLeftNavigationController = storyboardNavigationController.instantiateViewController(withIdentifier: "menuNavigationController") as! UISideMenuNavigationController
        SideMenuManager.default.menuLeftNavigationController = menuLeftNavigationController
        SideMenuManager.default.menuAddScreenEdgePanGesturesToPresent(toView: self.view, forMenu: UIRectEdge.left)
        
        SideMenuManager.default.menuWidth = UIScreen.main.bounds.width * 2 / 3
        SideMenuManager.default.menuFadeStatusBar = false
        SideMenuManager.default.menuAnimationPresentDuration = 0.3
        SideMenuManager.default.menuAnimationDismissDuration = 0.3
        SideMenuManager.default.menuPresentMode = .menuSlideIn
    }

    @objc @IBAction func showSideMenu() {
        present(SideMenuManager.default.menuLeftNavigationController!, animated: true, completion: nil)
    }
    
    @objc func searchTapped() {
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "SearchVC") as! SearchVC
        self.navigationController?.pushViewController(vc, animated: true)
    }
    @objc func cartTapped() {
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "CartVC") as! CartVC
        self.navigationController?.pushViewController(vc, animated: true)
//        let cartStoryboard = UIStoryboard(name: "CartStoryboard", bundle: nil)
//        let cartViewController = cartStoryboard.instantiateViewController(withIdentifier: "CartStoryboard") as! CartViewController
//        self.navigationController?.pushViewController(cartViewController, animated: true)
    }

    
//    func openFile(_ urlString : String!, vc2 : UIViewController! = nil){
//
//        if urlString.uppercased().contains(FileTypes.isPDF.rawValue){
//            let storyboard = UIStoryboard.init(name: "Main", bundle: nil)
//            let vc = storyboard.instantiateViewController(withIdentifier: "PDFViwerVC") as! PDFViwerVC
//            vc.urlString = urlString
//            let nv = UINavigationController.init(rootViewController: vc)
//
//            if vc2 != nil{
//                vc2.present(nv, animated: true, completion: nil)
//            }else{
//                self.present(nv, animated: true, completion: nil)
//            }
//        }else if urlString.uppercased().contains(FileTypes.isWord.rawValue){
//            self.showLoading()
//            DispatchQueue.global(qos: .background).async {
//                if let url = URL(string: urlString),
//                    let urlData = NSData(contentsOf: url) {
//                    let documentsPath = NSSearchPathForDirectoriesInDomains(.documentDirectory, .userDomainMask, true)[0];
//                    let lastPathComponent = (urlString as NSString).lastPathComponent
//                    let filePath="\(documentsPath)/\(lastPathComponent)"
//                    DispatchQueue.main.async {
//
//                        urlData.write(toFile: filePath, atomically: true)
//
//                        let activityViewController = UIActivityViewController(activityItems: [URL(fileURLWithPath: filePath)], applicationActivities: nil)
//                        self.hideLoading()
//
//                        activityViewController.excludedActivityTypes = [  ]
//                        self.present(activityViewController, animated: false, completion: nil)
//                    }
////                }
//                }else{
//                    self.hideLoading()
//                }
//            }
//
//        }
//        else{
//            var images = [LightboxImage]()
//
//            if let url = URL.init(string: urlString){
//                let im = LightboxImage.init(imageURL: url)
//                images.append(im)
//            }
//            self.imagesController = LightboxController(images: images)
//            self.imagesController.dynamicBackground = true
//
//            present(self.imagesController, animated: true, completion: nil)
//        }
//    }
//
    
    
    
}


