//
//  CartVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 11/3/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit

class CartVC: BaseVC,UITableViewDelegate,UITableViewDataSource {
    
    @IBOutlet weak var tableView : UITableView!
    @IBOutlet weak var calcBtn : UIButton!
    var currencyLocation : LocationInfo!
//    var currencyId : String = "1"
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        
        Communication.shared.locationInfo { (res) in
//            self.currencyId = res.CurrencyID.stringValue
            self.currencyLocation = res
            
        }
        
        self.title = "Cart"
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        
        self.calcBtn.isHidden = Provider.Cart.isEmpty
    }
    
    override func setupViews() {
        self.tableView.dataSource = self
        self.tableView.delegate = self
        self.tableView.rowHeight = UITableView.automaticDimension
        self.tableView.estimatedRowHeight = 100
        self.tableView.tableFooterView = UIView()
        
        self.tableView.register(UINib.init(nibName: "CartCell", bundle: nil), forCellReuseIdentifier: "cartCell")
    }
    
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return Provider.Cart.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "cartCell", for: indexPath) as! CartCell
        cell.selectionStyle = .none
        cell.tag = indexPath.row
        cell.parentVC = self
        cell.cartItem = Provider.Cart[indexPath.row]
        return cell
    }
    
    
    @IBAction func calcAction(){
        var products = [String]()
        var QTYs = [Int]()
        
        for i in Provider.Cart{
            products.append(i.ID)
            QTYs.append(i.QTY)
        }
        
        if User.isRegistered(){
            
            let alert1 = UIAlertController.init(title: "Do you want to use a promotion code?", message: nil, preferredStyle: UIAlertController.Style.alert)
            alert1.addAction(UIAlertAction.init(title: "NO", style: UIAlertAction.Style.default, handler: { (ac) in
                self.showLoading()
                Communication.shared.billRegistered(Products: products, QTYs: QTYs, Currency: self.currencyLocation.CurrencyID.stringValue, Customer: User.getID()) { (res) in
                    self.hideLoading()
                    
                    let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProceedPopupVC") as! ProceedPopupVC
                    vc.modalPresentationStyle = .overCurrentContext
                    vc.modalTransitionStyle = .crossDissolve
                    vc.parentVC = self
                    vc.products = products
                    vc.QTYs = QTYs
                    vc.currencyLocation = self.currencyLocation
                    vc.res = res
                    self.present(vc, animated: true, completion: nil)

//let alert = UIAlertController.init(title: "Total Price", message: res, preferredStyle: UIAlertController.Style.alert)
//alert.addAction(UIAlertAction.init(title: "OK", style: UIAlertAction.Style.default, handler: nil))
//self.present(alert, animated: true, completion: nil)
                }
            }))
            alert1.addAction(UIAlertAction.init(title: "YES", style: UIAlertAction.Style.default, handler: { (ac) in
                let vc = self.storyboard?.instantiateViewController(withIdentifier: "PromotionUseVC") as! PromotionUseVC
                vc.modalPresentationStyle = .overCurrentContext
                vc.modalTransitionStyle = .crossDissolve
                vc.parentVC = self
                vc.products = products
                vc.QTYs = QTYs
                vc.currencyLocation = self.currencyLocation
                self.present(vc, animated: true, completion: nil)
            }))
            
            self.present(alert1, animated: true, completion: nil)
            
        }else{
            self.showLoading()
            Communication.shared.bill(Products: products, QTYs: QTYs, Currency: self.currencyLocation.CurrencyID.stringValue) { (res) in
                self.hideLoading()
                let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProceedPopupVC") as! ProceedPopupVC
                vc.parentVC = self
                vc.modalPresentationStyle = .overCurrentContext
                vc.modalTransitionStyle = .crossDissolve
                vc.products = products
                vc.QTYs = QTYs
                vc.currencyLocation = self.currencyLocation
                vc.res = res
                self.present(vc, animated: true, completion: nil)

//                let alert = UIAlertController.init(title: "Total Price", message: res, preferredStyle: UIAlertController.Style.alert)
//                alert.addAction(UIAlertAction.init(title: "OK", style: UIAlertAction.Style.default, handler: nil))
//                self.present(alert, animated: true, completion: nil)
            }
        }
    }
    
//    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
//        return view.frame.width / 5
//    }
    
}
