//
//  CartViewController.swift
//  E-commerce
//
//  Created by juger on 8/12/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import Alamofire
import SwiftyJSON
import DropDown

class CartViewController: BaseVC , CartTableViewDelegate {
    
    //MARK:- Outlets
    @IBOutlet weak var tableView: UITableView!
    @IBOutlet weak var calculateButton: UIButton!
    @IBOutlet weak var currencyTextField: UITextField!
    @IBOutlet weak var currencyButton: UIButton!
    
    //MARK:- Variables
    var subUrl = "\(billURL)"
    var productsID : [String] = []
    var QTYS : [String] = []
    var currencyJson : [JSON] = []
    
    var priceOfProducts : String = ""
    
    var currencies : [String] = []
    let currencyDropDown = DropDown()
    var currencyID : Int = -1
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.subUrl = "\(currencyURL)"
        let params :[String : String] = ["SystemPasscode" : systemPasscode]
        self.getDataJson(params: params, i: 1)
        
        
        //TableView Delegate and data source
        tableView.dataSource = self
        tableView.delegate = self
        tableView.register(UINib(nibName : "CartTableViewCell" , bundle: nil), forCellReuseIdentifier: "cartCells")
        
        
        //Change the back button title and color
        self.navigationItem.backBarButtonItem = UIBarButtonItem(title: "", style: .plain, target: nil, action: nil)
        self.navigationItem.backBarButtonItem?.tintColor = UIColor(red: 0.29, green: 0.29, blue: 0.29, alpha: 1.0)
        tableView.reloadData()
        
        //To add bottom line to TextField
        currencyTextField.setBottomBorder()
        settingsDropDown()
        addActionToDropDown()
        
        calculateButton.layer.cornerRadius = 12
            calculateButton.layer.borderWidth = 2
        calculateButton.layer.borderColor  = UIColor.white.cgColor
        
        
        
    }
    
    
    //MARK: - Actions
    @IBAction func currencyTapped(_ sender: Any) {
        currencyDropDown.show()
    }
    @IBAction func calculateMyOrder(_ sender: UIButton) {
        if currencyID != -1 {
        if productAddedToCart.count != 0 {
            fillProductsQYTS()
            subUrl = "\(billURL)"
            var params : [String : Any] = ["SystemPasscode" : systemPasscode , "Products" : productsID,"QTYs" : QTYS , "Currency" : currencyID ]
            if let arr = JSON(productsID).rawString(){
                params["Products"] = arr
            }
            if let arr2 = JSON(QTYS).rawString(){
                params["QTYs"] = arr2
            }
            getDataJson(params: params,i : 0)
            print("products \(productsID) , QTYs \(QTYS)")
        }else
        {
            showErrorMessage(text: "Please add some product to Your cart")
        }
        }else {
            showErrorMessage(text: "Please select currency")
        }
    }
    
    //MARK: - Functions
    func addActionToDropDown()
    {
        currencyDropDown.selectionAction = { [unowned self] (index: Int, item: String) in
            print("Selected item: \(item) at index: \(index)")
            self.currencyTextField.text = item
            self.currencyID = self.currencyJson[index]["ID"].intValue
            print(self.currencyID)
        }
        
    }
    func settingsDropDown()
    {
        currencyDropDown.anchorView = currencyButton
        currencyDropDown.direction = .top
        currencyDropDown.bottomOffset = CGPoint(x: 0, y:-(currencyDropDown.anchorView?.plainView.bounds.height)!)
    }
    
    func showAlert() {
        let alert = UIAlertController(title:"Your products Price : \(priceOfProducts)" , message: "", preferredStyle: .alert)
        let okAction = UIAlertAction(title: "Go To Checkout", style: .default) {_ in
            self.performSegue(withIdentifier: "goToQuickCheckoutSegue", sender: self)
            
        }
        let cancelAction = UIAlertAction(title: "Cancel", style: .cancel, handler: nil)
        alert.addAction(okAction)
        alert.addAction(cancelAction)
        self.present(alert, animated: true, completion: nil)
        
    }
    func fillProductsQYTS()
    {
        productsID = []
        QTYS = []
        for i in 0 ..< productAddedToCart.count
        {
            productsID.append(productAddedToCart[i]["Data"]["Data"]["ID"].stringValue)
            let indexPath = IndexPath(row: i, section: 0)
            let cell = tableView.cellForRow(at: indexPath) as! CartTableViewCell
            QTYS.append(cell.numberOfProductsLabel.text!)
        }
    }
    //get data from Web
    func getDataJson(params : [String : Any], i : Int){
        showLoading()
        let url : String = BASEURL + subUrl
        Alamofire.request(url, method: .post, parameters: params).responseJSON { response in
            if response.result.isSuccess {
                print("Success")
                let calData : JSON = JSON(response.result.value!)
                let message = calData["ErrorMessage"].stringValue
                if message == "" {
                    if i == 0 {
                        self.hideLoading()
                        self.priceOfProducts = calData["Data"]["Data"].stringValue
                        self.showAlert()
                    }else if i == 1 { //To Get the Currencies
                        self.currencyJson = calData["Data"]["Data"].arrayValue
                        for i in 0 ..< self.currencyJson.count
                        {
                            self.currencies.append(self.currencyJson[i]["Name"].stringValue)
                        }
                        self.currencyDropDown.dataSource = self.currencies
                        self.hideLoading()
                    }else
                    {
                        self.hideLoading()
                        self.showErrorMessage(text: message)
                    }
                }else {
                    self.hideLoading()
                    self.showErrorMessage(text: "Please check your internet connection")
                }
            }
        }
    }
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        if segue.identifier == "goToQuickCheckoutSegue"
        {
            print("in prepare segue")
            let vc = segue.destination as! QuickCheckoutViewController
            vc.productsID = productsID
            vc.QTYS = QTYS
            vc.currencyID = self.currencyID
            
        }
    }
    
    override func viewWillTransition(to size: CGSize, with coordinator: UIViewControllerTransitionCoordinator) {
        super.viewWillTransition(to: size, with: coordinator)
        tableView.reloadData()
    }
    override var prefersStatusBarHidden: Bool {
        return false
    }
    func removeItems(idCell: CartTableViewCell) {
        productAddedToCart.remove(at: (tableView.indexPath(for: idCell)?.row)!)
        let indexPath = tableView.indexPath(for: idCell)
        tableView.beginUpdates()
        tableView.deleteRows(at: [indexPath!], with: .automatic)
        tableView.endUpdates()
        showErrorMessage(text: "Deleted Done")
        //  print(productAddedToCart.count)
    }
    
    
    
    
}

extension CartViewController : UITableViewDelegate , UITableViewDataSource {
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        
        if isLandscape {
            return  view.frame.width / 5
        }else
        {
            return  view.frame.height / 5
        }
        
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        print("productAdded : \(productAddedToCart.count)")
        return productAddedToCart.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "cartCells", for: indexPath) as! CartTableViewCell
        cell.discripationProductLabel.text = productAddedToCart[indexPath.row]["Data"]["Data"]["Name"].stringValue
        cell.productImageView.sd_setImage(with: URL(string: productAddedToCart[indexPath.row]["Data"]["Data"]["Images"]["NoColor"][0].stringValue), completed: nil)
        cell.productPriceLabel.text = productAddedToCart[indexPath.row]["Data"]["Data"]["Price"].stringValue + "$"
        cell.idCell = indexPath.row
        cell.delegate = self
        
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
    }
    
    
}
