//
//  CategoriesVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 10/31/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit

class CategoriesVC: BaseVC {

    @IBOutlet weak var collectionView : UICollectionView!

    var baseCategory : CategoryObj!
    var categories = [CategoryObj]()
    var products = [Product]()
    
    override func viewDidLoad() {
        super.viewDidLoad()

//        self.setupRightButtons()

        getData()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        
        self.setupRightBarButtons()
    }
    
    override func setupViews() {
        self.collectionView.delegate = self
        self.collectionView.dataSource = self
        self.collectionView.addSubview(ref)
        
        self.collectionView.register(UINib.init(nibName: "CategoryCell", bundle: nil), forCellWithReuseIdentifier: "categoryCell")
        self.collectionView.register(UINib.init(nibName: "ProductCell", bundle: nil), forCellWithReuseIdentifier: "productCell")
        
        if baseCategory == nil{
            self.title = "Categories"
            self.setupLeftButton()
            self.setupSideMenu()
        }else{
            self.title = baseCategory.Name
            self.categories = baseCategory.categories
        }
    }
    
    override func getRefreshing() {
        if baseCategory == nil{
            Communication.shared.categories { (res) in
                self.hideLoading()
                
                self.categories = CategoryObj.loadNeasted(res, i: 0)
                self.refreshData()
            }
        }else{
            Communication.shared.category(ID: self.baseCategory.ID.stringValue) { (res) in
                self.hideLoading()
                
                self.products = res.Products
                self.refreshData()
            }
        }
    }
    

    func refreshData(){
        self.collectionView.reloadData()
    }

    
}

extension CategoriesVC : UICollectionViewDelegate,UICollectionViewDataSource,UICollectionViewDelegateFlowLayout{
    
    func numberOfSections(in collectionView: UICollectionView) -> Int {
        return 2
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return (section == 0) ? categories.count : products.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        
        if indexPath.section == 0{
        
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "categoryCell", for: indexPath) as! CategoryCell
            cell.category = self.categories[indexPath.row]
            return cell
        }else{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "productCell", for: indexPath) as! ProductCell
            cell.tag = indexPath.row
            cell.parentVC = self
            cell.product = self.products[indexPath.row]
            return cell
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        if indexPath.section == 0{
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "CategoriesVC") as! CategoriesVC
            vc.baseCategory = self.categories[indexPath.row]
            self.navigationController?.pushViewController(vc, animated: true)
        }else{
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductDetailsVC") as! ProductDetailsVC
            vc.productId = self.products[indexPath.row].ID.stringValue
            vc.product = self.products[indexPath.row]
            self.navigationController?.pushViewController(vc, animated: true)
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, referenceSizeForHeaderInSection section: Int) -> CGSize {
        if section == 1{
            return (self.products.isEmpty) ? CGSize.zero : CGSize.init(width: self.view.bounds.width, height: 40)
        }
        return CGSize.zero
    }
    
    func collectionView(_ collectionView: UICollectionView, viewForSupplementaryElementOfKind kind: String, at indexPath: IndexPath) -> UICollectionReusableView {

        let headerView = collectionView.dequeueReusableSupplementaryView(ofKind: UICollectionView.elementKindSectionHeader, withReuseIdentifier: "headerCell", for: indexPath)

        return headerView
    }

    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        
        if indexPath.section == 0{
            let category = self.categories[indexPath.row]
            let height = self.view.bounds.width / 3
            let width = (category.IsRectangle.Boolean) ? self.view.bounds.width : self.view.bounds.width / 2
            return CGSize.init(width: width, height: height)
        }else{
            let height = self.view.bounds.height / 2
            let width = self.view.bounds.width / 2
            return CGSize.init(width: width, height: height)
        }
        
    }
    
}
