//
//  CategoryProductsViewController.swift
//  E-commerce
//
//  Created by juger on 9/23/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import SideMenu
import Alamofire
import SwiftyJSON
import SDWebImage

class CategoryProductsViewController: BaseVC {

    //MARK: - Variables
    var subUrl = "\(categoriesURL)"
    var isGetDataSuccess : Bool = false
    let height : CGFloat = 67.0
    var productsItems : [JSON] = []
    var catItems : [JSON] = []
    
    
    
    //MARK: - Outlets
    @IBOutlet weak var categoryCollectionView: UICollectionView!
    @IBOutlet weak var productsCollectionView: UICollectionView!

    @IBOutlet weak var productsLabel: UILabel!
    @IBOutlet weak var heightCategoryCollectionView: NSLayoutConstraint!
    @IBOutlet weak var heightProductsCollectionView: NSLayoutConstraint!
    @IBOutlet weak var scrollView: UIScrollView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        productsItems = productsStackContent.last!
        catItems = catStackContent.last!
        
        //set the cells for categoryCollectionView
        categoryCollectionView.delegate = self
        categoryCollectionView.dataSource = self
        categoryCollectionView.register(UINib(nibName: "CategoryCollectionViewCell", bundle : nil), forCellWithReuseIdentifier: "categoryCell2")
        
        //set the cells for productsCollectionView
        productsCollectionView.delegate = self
        productsCollectionView.dataSource = self
        productsCollectionView.register(UINib(nibName : "ItemsCollectionViewCell" , bundle : nil), forCellWithReuseIdentifier: "itemsCells")
        
        productsLabel.attributedText = NSAttributedString(string: "Products:", attributes:
            [.underlineStyle: NSUnderlineStyle.single.rawValue])
        
        if !productsItems.isEmpty {
            self.productsLabel.isHidden = false
            
        }
    }
    
    
    
    //MARK: - Actions
    @IBAction func searchTapped(_ sender: Any) {
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "SearchStoryboard") as! SearchViewController
        self.navigationController?.pushViewController(vc, animated: true)
    }
    @IBAction func backButtonTapped(_ sender: UIButton) {
        if !catStackContent.isEmpty
        {
            catStackContent.removeLast()
            
        }
        if !productsStackContent.isEmpty {
            productsStackContent.removeLast()
        }
        
        categoryCollectionView.reloadData()
        productsCollectionView.reloadData()
    }
    @IBAction func cartTapped(_ sender: UIBarButtonItem) {
        let cartStoryboard = UIStoryboard(name: "CartStoryboard", bundle: nil)
        let cartViewController = cartStoryboard.instantiateViewController(withIdentifier: "CartStoryboard") as! CartViewController
        self.navigationController?.pushViewController(cartViewController, animated: true)
        
        
    }
    
    @IBAction func showSideMenu(_ sender: UIBarButtonItem) {
        present(SideMenuManager.default.menuLeftNavigationController!, animated: true, completion: nil)    }
    
    //MARK:- Functions
    override func viewWillDisappear(_ animated : Bool) {
        super.viewWillDisappear(animated)
        
        if self.isMovingFromParent {
            if !catStackContent.isEmpty
            {
                catStackContent.removeLast()
                
            }
            if !productsStackContent.isEmpty {
                productsStackContent.removeLast()
            }
        }
    }
    func delay(seconds: Double, completion: @escaping ()-> Void) {
        DispatchQueue.main.asyncAfter(deadline: .now() + seconds, execute: completion)
    }
    
    func getIdsCatBase()
    {
        var isBase = false
        for i in 0 ..< categroyDataJSON["Data"]["Data"].count
        {
            isBase = false
            
            for j in 0 ..< categroyDataJSON["Data"]["Data"].count
            {
                let child = categroyDataJSON["Data"]["Data"][j]["Child"].arrayValue
                print(child)
                if child.contains(categroyDataJSON["Data"]["Data"][i]["ID"])
                {
                    print(true)
                    isBase = true
                    break
                }
                
            }
            if !isBase {
                arrayOfBaseCat.append(categroyDataJSON["Data"]["Data"][i])
            }
            
        }
    }
    func updateConstraints() {
        // You should handle UI updates on the main queue, whenever possible
        DispatchQueue.main.async {
            self.heightCategoryCollectionView.constant = self.categoryCollectionView.contentSize.height
            self.heightProductsCollectionView.constant = self.productsCollectionView.contentSize.height
            self.view.layoutIfNeeded()
            self.scrollView.layoutIfNeeded()
        }
    }
    //get data from Web
    func getDataJson(params : [String : String] , i : Int){
        let url : String = BASEURL + subUrl
        showLoading()
        Alamofire.request(url, method: .post, parameters: params).responseJSON { response in
            if response.result.isSuccess {
                
                print("Success")
                var allCategoryJson : JSON = JSON(response.result.value!)
                let message = allCategoryJson["Data"]["ErrorMessage"].stringValue
                if message == "" {
                    if i == 0 {//To get categories
                        self.hideLoading()
                        categroyDataJSON = allCategoryJson
                        self.getIdsCatBase()
                    }else // To get products
                    {
                        self.hideLoading()
                        productsDataJSON = allCategoryJson["Data"]["Data"]["Products"].arrayValue
                        print("productsDataJSON : \(productsDataJSON)")
                        productsStackContent.append(productsDataJSON)
                        let vc = self.storyboard?.instantiateViewController(withIdentifier: "CategoryProductsStoryboard") as! CategoryProductsViewController
                        self.navigationController?.pushViewController(vc, animated: true)
                    }
                    self.isGetDataSuccess = true
                    
                    
                }else
                {
                    self.hideLoading()
                    self.showErrorMessage(text: message)
                }
                self.categoryCollectionView.reloadData()
                self.productsCollectionView.reloadData()
            }else {
                
                self.hideLoading()
                print("Failed requset api")
                self.showErrorMessage(text: "Please Check your Internet Connection")
            }
        }
    }
    override var prefersStatusBarHidden: Bool {
        return false
    }
    override func viewWillTransition(to size: CGSize, with coordinator: UIViewControllerTransitionCoordinator) {
        super.viewWillTransition(to: size, with: coordinator)
        
        if UIDevice.current.orientation.isPortrait {
            isLandscape = false
        }else
        {
            isLandscape = true
        }
        categoryCollectionView.reloadData()
        productsCollectionView.reloadData()
        
        
        
    }
    
    
    
}

extension CategoryProductsViewController: UICollectionViewDelegate,UICollectionViewDataSource,UICollectionViewDelegateFlowLayout {
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        updateConstraints()
        if collectionView.tag == 0 {
            return catItems.count
        }
        if collectionView.tag == 1
        {
            return productsItems.count
        }
        
        return 0
        
    }
    
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        
        if collectionView.tag == 1
        {
            print("in products cell")
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "itemsCells", for: indexPath) as! ItemsCollectionViewCell
            let temp = productsItems
            let tempImagesNoColor = temp[indexPath.item]["Images"]["NoColor"].arrayValue
            let tempImagesColor = temp[indexPath.item]["Images"]["Color"].arrayValue
            if tempImagesNoColor.count != 0 {
            cell.imageOfProduct.sd_setImage(with: URL(string: tempImagesNoColor[0].stringValue), completed: nil)
            }else if tempImagesNoColor.count == 0 && tempImagesColor.count != 0 {
                 cell.imageOfProduct.sd_setImage(with: URL(string: tempImagesColor[0]["ProductImages"][0].stringValue), completed: nil)
            }
            cell.nameOfProduct.text = temp[indexPath.item]["Name"].stringValue
            cell.productID = temp[indexPath.item]["ID"].intValue
            cell.priceOfProduct.text = temp[indexPath.item]["Price"].stringValue + "$"
            return cell
        }
        if collectionView.tag == 0 {
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "categoryCell2", for: indexPath) as! CategoryCollectionViewCell
            // let itemId = dataJSON["Data"]["Data"][indexPath.item]["ID"].intValue
            //        print(arrayOfBaseCatId.contains(itemId))
            tempDataJSON = catItems
            cell.nameOfProduct.text = tempDataJSON[indexPath.item]["Name"].stringValue
            cell.imageOfProduct.sd_setImage(with: URL(string: tempDataJSON[indexPath.item]["MobileImageURL"].stringValue), completed: nil)
            return cell
        }
        
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "itemsCells", for: indexPath) as! ItemsCollectionViewCell
        
        return cell
        
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        if collectionView.tag == 0 {
                let isRectangle : Bool = catItems[indexPath.item]["IsRectangle"].boolValue
                if isRectangle {
                    let sizePortrait1 = CGSize.init(width: self.view.frame.width , height: self.view.frame.height / 6)
                    
                    let sizeLandscape1 = CGSize.init(width: self.view.frame.width , height: self.view.frame.width / 5)
                    if isLandscape {
                        //  print("landscape")
                        return sizeLandscape1
                    }else {
                        //   print("portrait")
                        return sizePortrait1
                    }
                    
                }else
                {
                    
                    let sizePortrait2 = CGSize.init(width: self.view.frame.width / 2 , height: self.view.frame.height / 5)
                    
                    let sizeLandscape2 = CGSize.init(width: (self.view.frame.width / 2 ), height: self.view.frame.width / 4)
                    if isLandscape {
                        print("landscape category")
                        return sizeLandscape2
                    }else {
                        //   print("portrait")
                        return sizePortrait2
                    }
                }
        }
        
        if collectionView.tag == 1 {
            let sizePortrait = CGSize.init(width: self.view.frame.width / 2 , height: self.view.frame.height / 2.3 )
            let sizeLandscape = CGSize.init(width: self.view.frame.width / 2 , height: self.view.frame.width / 2.3 )
            if UIDevice.current.orientation.isLandscape || isLandscape {
                return sizeLandscape
            }else {
                return sizePortrait
            }
        }
        
        
        let sizePortrait1 = CGSize.init(width: self.view.frame.width , height: self.view.frame.height / 1)
        return sizePortrait1
        
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        
        
        
        if collectionView.tag == 0 {
            var id : Int = 0
                let childs = catItems[indexPath.item]["Child"].arrayValue
                id = catItems[indexPath.item]["ID"].intValue
                var temp : [JSON] = []
                for i in 0 ..< categroyDataJSON["Data"]["Data"].count
                {
                    let id = categroyDataJSON["Data"]["Data"][i]["ID"]
                    if childs.contains(id)
                    {
                        temp.append(categroyDataJSON["Data"]["Data"][i])
                    }
                }
            self.navigationItem.backBarButtonItem = UIBarButtonItem(title: catItems[indexPath.item]["Name"].stringValue, style: .plain, target: nil, action: nil)
            self.navigationItem.backBarButtonItem?.tintColor = UIColor(red: 0.29, green: 0.29, blue: 0.29, alpha: 1.0)
                
            catStackContent.append(temp)
            subUrl = "\(categoryURL)"
            let params : [String : String] = ["SystemPasscode" : systemPasscode ,"ID" : String(id)]
            getDataJson(params: params, i: 1)
        }
        if collectionView.tag == 1 {
            let sb = UIStoryboard(name: "ItemViewerStoryboard", bundle: nil)
            let vc = sb.instantiateViewController(withIdentifier: "ItemViewerStoryboard") as! ItemViewerViewController
            vc.productID = productsItems[indexPath.item]["ID"].intValue
            self.navigationItem.backBarButtonItem = UIBarButtonItem(title: "", style: .plain, target: nil, action: nil)
            self.navigationItem.backBarButtonItem?.tintColor = UIColor(red: 0.29, green: 0.29, blue: 0.29, alpha: 1.0)
            self.navigationController?.pushViewController(vc, animated: true)
        }
        
    }
    
    
}
