//
//  ChancePasswordVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 10/27/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit
import PasswordTextField

class ChangePasswordVC: BaseVC {

    @IBOutlet weak var tfOld : PasswordTextField!
    @IBOutlet weak var tfNew : PasswordTextField!
    @IBOutlet weak var tfNew2 : PasswordTextField!
    @IBOutlet weak var vv : UIView!

    
    override func viewDidLoad() {
        super.viewDidLoad()

        self.vv.addGestureRecognizer(UITapGestureRecognizer.init(target: self, action: #selector(self.dissmiss)))
    }
    
    @IBAction func submitAction(){
        let old = tfOld.text!
        let new = tfNew.text!
        let new2 = tfNew2.text!

        if old.isEmpty ||
            new.isEmpty ||
            new2.isEmpty{
            self.showErrorMessage(text: "Please enter all fields")
            return
        }
        
        if new != new2{
            self.showErrorMessage(text: "Passwords don't match")
            return
        }

        self.showLoading()
        Communication.shared.changePassword(OldPassword: old, NewPassword: new) { (res) in
            self.hideLoading()
            self.showErrorMessage(text: "Your password has been changed")
            self.dismiss(animated: true, completion: nil)
        }
            
    }
    

    override func onTouch() {
        
    }
    
}
