//
//  CheckOutTVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 11/14/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit
import DropDown

class CheckOutTVC: BaseTVC {
    
    @IBOutlet weak var tfAddress : UITextField!
    
    @IBOutlet weak var favBtn : CheckBox!
    @IBOutlet weak var gpsBtn : CheckBox!
    @IBOutlet weak var manBtn : CheckBox!
    
    @IBOutlet weak var stackPlaces : UIStackView!
    @IBOutlet weak var stackAddresses : UIStackView!
    @IBOutlet weak var stackAddresses1 : UIStackView!

    
    @IBOutlet weak var tfFav : UITextField!
    
    @IBOutlet weak var tvPlace : UITextView!
    @IBOutlet weak var tvCity : UITextView!
    @IBOutlet weak var tvRegion : UITextView!

    @IBOutlet weak var tfShipping : UITextField!
    
    @IBOutlet weak var cashVV : UIView!
    @IBOutlet weak var configurePaymentVV : UIView!
    @IBOutlet weak var cashBtn : CheckBox!


    @IBOutlet weak var totalLbl : UILabel!
    
    var addressDropdown = DropDown()
    var placesDropdown = DropDown()
    var citiesDropdown = DropDown()
    var regionsDropdown = DropDown()
    var shippingDropdown = DropDown()

    var addresses = [Address]()
    var places = [Place]()
    var companies = [ShippingCompany]()
    
    var products = [String]()
    var QTYs = [Int]()
    var currencyLocation : LocationInfo!
    var publicCode : String!
    var privateCode : String!
    var res = String()
    
    var selectedAddress : Address!
    var selectedShipping : ShippingCompany!
    var selectedPlace : Place!
    var selectedCity : City!
    var selectedRegion : Region!
    
    var lat : Double!
    var long : Double!

    
    override func viewDidLoad() {
        super.viewDidLoad()

        self.title = "Checkout"
        self.totalLbl.text = res + " " + self.currencyLocation.symbol
        
        self.tableView.rowHeight = UITableView.automaticDimension
        self.tableView.estimatedRowHeight = 100
        self.tableView.reloadData()
        
        
        if userLoggedIn{
            self.favBtn.isChecked = true
            self.stackPlaces.isHidden = true
            Provider.shared.startUpdatingLocation()
            
            Communication.shared.myAddresses { (res) in
                self.addresses = res
                self.setupAddresses()
            }
        }else{
            self.favBtn.isChecked = false
            self.stackPlaces.isHidden = true
            self.stackAddresses1.isHidden = true
            self.stackAddresses.isHidden = true
            
            self.manBtn.isChecked = true
            self.stackPlaces.isHidden = false
            self.setupPaymentsTypes()
        }
        
        cashBtn.isChecked = true
        
        
        Communication.shared.shippingCompany { (res) in
            self.companies = res
            self.setupShipping()
        }
        
        Communication.shared.place { (res) in
            self.places = res
            self.setupPlaces()
            
            if !res.isEmpty{
                self.tvPlace.text = res.first?.Name
                self.selectedPlace = self.places[0]
                
                self.selectedCity = nil
                self.selectedRegion = nil
                self.tvCity.text = nil
                self.tvRegion.text = nil
                
                self.setupCities()
                self.tableView.reloadData()
            }
        }
    }
    
    func setupAddresses(){
        addressDropdown.dataSource = self.addresses.map({$0.Name})
        addressDropdown.anchorView = self.tfFav
        addressDropdown.direction = .any
        addressDropdown.bottomOffset = CGPoint(x: 0, y: tfFav.bounds.height)
        
        addressDropdown.selectionAction = { [unowned self] (index, item) in
            self.tfFav.text = item
            self.selectedAddress = self.addresses[index]
        }
    }
    
    func setupShipping(){
        shippingDropdown.dataSource = self.companies.map({$0.Name})
        shippingDropdown.anchorView = self.tfShipping
        shippingDropdown.direction = .any
        shippingDropdown.bottomOffset = CGPoint(x: 0, y: tfShipping.bounds.height)
        
        shippingDropdown.selectionAction = { [unowned self] (index, item) in
            self.tfShipping.text = item
            self.selectedShipping = self.companies[index]
        }
    }
    
    func setupPlaces(){
        placesDropdown.dataSource = self.places.map({$0.Name})
        placesDropdown.anchorView = self.tvPlace
        placesDropdown.direction = .any
        placesDropdown.bottomOffset = CGPoint(x: 0, y: tvPlace.bounds.height)
        
        placesDropdown.selectionAction = { [unowned self] (index, item) in
            self.tvPlace.text = item
            self.selectedPlace = self.places[index]
            
            self.selectedCity = nil
            self.selectedRegion = nil
            self.tvCity.text = nil
            self.tvRegion.text = nil
            
            self.setupCities()
            self.tableView.reloadData()
            print("SELECTed")
        }
    }
    
    func setupCities(){
        citiesDropdown.dataSource = self.selectedPlace.cities.map({$0.Name})
        citiesDropdown.anchorView = self.tvCity
        citiesDropdown.direction = .any
        citiesDropdown.bottomOffset = CGPoint(x: 0, y: tvCity.bounds.height)
        
        if !self.selectedPlace.cities.map({$0.Name}).isEmpty{
            self.tvCity.text = self.selectedPlace.cities.map({$0.Name}).first
            self.selectedCity = self.selectedPlace.cities[0]
            
            self.selectedRegion = nil
            self.tvRegion.text = nil
            
            self.setupRegions()
            self.tableView.reloadData()
        }
        
        citiesDropdown.selectionAction = { [unowned self] (index, item) in
            self.tvCity.text = item
            self.selectedCity = self.selectedPlace.cities[index]
            
            self.selectedRegion = nil
            self.tvRegion.text = nil

            self.setupRegions()
            self.tableView.reloadData()
        }
    }

    func setupRegions(){
        regionsDropdown.dataSource = self.selectedCity.regions.map({$0.Name})
        regionsDropdown.anchorView = self.tvRegion
        regionsDropdown.direction = .any
        regionsDropdown.bottomOffset = CGPoint(x: 0, y: tvRegion.bounds.height)
        
        if !self.selectedCity.regions.map({$0.Name}).isEmpty{
            self.tvRegion.text = self.selectedCity.regions.map({$0.Name}).first
            self.selectedRegion = self.selectedCity.regions[0]
            self.tableView.reloadData()
        }
        
        regionsDropdown.selectionAction = { [unowned self] (index, item) in
            self.tvRegion.text = item
            self.selectedRegion = self.selectedCity.regions[index]
            self.tableView.reloadData()
        }
    }
    
    @IBAction func changeLocation(_ sender : CheckBox){
      
//        sender.setImage(sender.checkedImage, for: UIControl.State.normal)
        sender.isChecked = true
        
        self.favBtn.isChecked = sender.tag == 1
        self.gpsBtn.isChecked = sender.tag == 2
        self.manBtn.isChecked = sender.tag == 3

        
        if sender.tag == 1{
            self.stackPlaces.isHidden = true
            self.stackAddresses.isHidden = false
        }else if sender.tag == 2{
            self.stackPlaces.isHidden = true
            self.stackAddresses.isHidden = true
            self.getCurrentLocation()
        }else{
            self.stackPlaces.isHidden = false
            self.stackAddresses.isHidden = true
        }
        
        self.tableView.reloadData()
    }
    
    
    
    @IBAction func openAddresses(){
        self.addressDropdown.show()
    }
    @IBAction func openPlaces(){
        self.placesDropdown.show()
    }
    @IBAction func openCities(){
        self.citiesDropdown.show()
    }
    @IBAction func openRegions(){
        self.regionsDropdown.show()
    }
    @IBAction func openShipping(){
        self.shippingDropdown.show()
    }

    @IBAction func configurePayment(){
        let alert = UIAlertController.init(title: "Would you like t use store credit?", message: nil, preferredStyle: UIAlertController.Style.alert)
        alert.addAction(UIAlertAction.init(title: "YES", style: UIAlertAction.Style.default, handler: { (ac) in
            self.showLoading()
            Communication.shared.getStoreCredit(CurrencyID: self.currencyLocation.CurrencyID.stringValue) { (res) in
                self.hideLoading()
                
                if let store = Double(res){
                    if let total = Double(self.res){
                        if total > store{
                            self.setupPaymentsTypes()
                        }
                    }
                }
            }
        }))
        alert.addAction(UIAlertAction.init(title: "NO", style: UIAlertAction.Style.cancel, handler: { (ac) in
            self.setupPaymentsTypes()
        }))
        self.present(alert, animated: true, completion: nil)
    }
    
    
    func setupPaymentsTypes(){
        self.cashVV.isHidden = false
        self.configurePaymentVV.isHidden = true
        
    }


    func getCurrentLocation(){
        if Provider.isLocationPermissionGranted(){
            if let location = Provider.shared.locationManager.location{
                self.lat = location.coordinate.latitude
                self.long = location.coordinate.longitude
                print(location.coordinate)
            }
        }else{
            let alert = UIAlertController(title: "Need Authorization", message: "This app is unusable if you don't authorize this app to use your location!", preferredStyle: .alert)
            alert.addAction(UIAlertAction(title: "Cancel", style: .cancel, handler: nil))
            alert.addAction(UIAlertAction(title: "Settings", style: .default, handler: { _ in
                let url = URL(string: UIApplication.openSettingsURLString)!
                UIApplication.shared.openURL(url)
            }))
            self.present(alert, animated: true, completion: nil)
        }
    }

    
    
    @IBAction func orderAction(){
        print("ORDERING")
        let address = self.tfAddress.text!
        var region = "1"
        
        if let r = self.selectedRegion{
            region = r.ID.stringValue
        }
        if let a = self.selectedAddress{
            region = a.RegionID.stringValue
        }
        
        if User.isRegistered(){
            self.showLoading()
            Communication.shared.order(Address: address, Products: self.products, QTYs: self.QTYs, StoreCredit: "0", ShippingCompany: self.selectedShipping.ID.stringValue, Public: self.publicCode, Private: self.privateCode, Lat: self.lat, Lon: self.long, Region: region,Currency : self.currencyLocation.CurrencyID.stringValue) { (res) in
                self.hideLoading()
                self.showErrorMessage(text: "Your order has been sent successfully")
                
                Provider.Cart.removeAll()
                
                let vc = self.storyboard?.instantiateViewController(withIdentifier: "HomeVC") as! HomeVC
                self.navigationController?.pushViewController(vc, animated: true)
            }
        }else{
            self.showLoading()
            Communication.shared.order(Address: address, Products: self.products, QTYs: self.QTYs, StoreCredit: "0", ShippingCompany: self.selectedShipping.ID.stringValue, Lat: self.lat, Lon: self.long, Region: region,Currency : self.currencyLocation.CurrencyID.stringValue) { (res) in
                self.hideLoading()
                self.showErrorMessage(text: "Your order has been sent successfully")
                
                Provider.Cart.removeAll()
                
                let vc = self.storyboard?.instantiateViewController(withIdentifier: "HomeVC") as! HomeVC
                self.navigationController?.pushViewController(vc, animated: true)
            }
        }
    }

    
    override func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return UITableView.automaticDimension
    }
    
    override func tableView(_ tableView: UITableView, willDisplay cell: UITableViewCell, forRowAt indexPath: IndexPath) {
        cell.selectionStyle = .none
    }
}
