//
//  ContactusVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 11/17/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit

class ContactusVC: BaseVC {

    @IBOutlet weak var tfName : UITextField!
    @IBOutlet weak var tfEmail : UITextField!
    @IBOutlet weak var tvMessage : UITextView!

    
    override func viewDidLoad() {
        super.viewDidLoad()

        self.setupLeftButton()
        self.setupSideMenu()

        self.title = "Contact Us"
    }
    
    
    @IBAction func sendAction(){
        let name = self.tfName.text!
        let email = self.tfEmail.text!
        let message = self.tvMessage.text!

        
        self.showLoading()
        Communication.shared.contactUs(Name: name, Email: email, Message: message) { (res) in
            self.hideLoading()
           self.showErrorMessage(text: "Your message has been sent successfully")
            self.navigationController?.popViewController(animated: true)
        }
        
    }
    

}
