//
//  ElanatVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 11/3/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit

class ElanatVC: BaseVC {
    
    @IBOutlet weak var cvGoldFull : UICollectionView!
    @IBOutlet weak var cvGoldMid : UICollectionView!
    @IBOutlet weak var cvGoldSmall : UICollectionView!
    
    @IBOutlet weak var cvSilverFull : UICollectionView!
    @IBOutlet weak var cvSilverMid : UICollectionView!
    @IBOutlet weak var cvSilverSmall : UICollectionView!
    
    @IBOutlet weak var cvBronzeFull : UICollectionView!
    @IBOutlet weak var cvBronzeMid : UICollectionView!
    @IBOutlet weak var cvBronzeSmall : UICollectionView!
    
    @IBOutlet weak var cvGoldFullHeight : NSLayoutConstraint!
    @IBOutlet weak var cvGoldMidHeight : NSLayoutConstraint!
    @IBOutlet weak var cvGoldSmallHeight : NSLayoutConstraint!
    @IBOutlet weak var cvSilverFullHeight : NSLayoutConstraint!
    @IBOutlet weak var cvSilverMidHeight : NSLayoutConstraint!
    @IBOutlet weak var cvSilverSmallHeight : NSLayoutConstraint!
    @IBOutlet weak var cvBronzeFullHeight : NSLayoutConstraint!
    @IBOutlet weak var cvBronzeMidHeight : NSLayoutConstraint!
    @IBOutlet weak var cvBronzeSmallHeight : NSLayoutConstraint!


    
    var goldsFull = [Elan]()
    var goldsMid = [Elan]()
    var goldsSmall = [Elan]()
    
    var silversFull = [Elan]()
    var silversMid = [Elan]()
    var silversSmall = [Elan]()
    
    var bronzesFull = [Elan]()
    var bronzesMid = [Elan]()
    var bronzesSmall = [Elan]()
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.title = "Advertisements"
        
//        self.setupRightButtons()
        self.setupLeftButton()
        self.setupSideMenu()

        getData()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        
        self.setupRightBarButtons()
    }

    
    override func getRefreshing() {
        Communication.shared.elanat { (res) in
            self.hideLoading()
            
            self.goldsFull = res.Gold.Full
            self.goldsMid = res.Gold.Mid
            self.goldsSmall = res.Gold.Small
            
            self.silversFull = res.Silver.Full
            self.silversMid = res.Silver.Mid
            self.silversSmall = res.Silver.Small
            
            self.bronzesFull = res.Bronze.Full
            self.bronzesMid = res.Bronze.Mid
            self.bronzesSmall = res.Bronze.Small
            
            self.refreshData()
        }
    }
    
    override func setupViews() {
        self.refreshData()
        
        self.cvGoldFull.delegate = self
        self.cvGoldFull.dataSource = self
        self.cvGoldMid.delegate = self
        self.cvGoldMid.dataSource = self
        self.cvGoldSmall.delegate = self
        self.cvGoldSmall.dataSource = self

        self.cvSilverFull.delegate = self
        self.cvSilverFull.dataSource = self
        self.cvSilverMid.delegate = self
        self.cvSilverMid.dataSource = self
        self.cvSilverSmall.delegate = self
        self.cvSilverSmall.dataSource = self

        self.cvBronzeFull.delegate = self
        self.cvBronzeFull.dataSource = self
        self.cvBronzeMid.delegate = self
        self.cvBronzeMid.dataSource = self
        self.cvBronzeSmall.delegate = self
        self.cvBronzeSmall.dataSource = self

        
        self.cvGoldFull.register(UINib.init(nibName: "ElanCell", bundle: nil), forCellWithReuseIdentifier: "cell")
        self.cvGoldMid.register(UINib.init(nibName: "ElanCell", bundle: nil), forCellWithReuseIdentifier: "cell")
        self.cvGoldSmall.register(UINib.init(nibName: "ElanCell", bundle: nil), forCellWithReuseIdentifier: "cell")
        
        self.cvSilverFull.register(UINib.init(nibName: "ElanCell", bundle: nil), forCellWithReuseIdentifier: "cell")
        self.cvSilverMid.register(UINib.init(nibName: "ElanCell", bundle: nil), forCellWithReuseIdentifier: "cell")
        self.cvSilverSmall.register(UINib.init(nibName: "ElanCell", bundle: nil), forCellWithReuseIdentifier: "cell")
        
        self.cvBronzeFull.register(UINib.init(nibName: "ElanCell", bundle: nil), forCellWithReuseIdentifier: "cell")
        self.cvBronzeMid.register(UINib.init(nibName: "ElanCell", bundle: nil), forCellWithReuseIdentifier: "cell")
        self.cvBronzeSmall.register(UINib.init(nibName: "ElanCell", bundle: nil), forCellWithReuseIdentifier: "cell")
    }
    
    func refreshData(){
//        self.cvGoldFull.isHidden = self.goldsFull.isEmpty
//        self.cvGoldMid.isHidden = self.goldsMid.isEmpty
//        self.cvGoldSmall.isHidden = self.goldsSmall.isEmpty
//
//        self.cvSilverFull.isHidden = self.silversFull.isEmpty
//        self.cvSilverMid.isHidden = self.silversMid.isEmpty
//        self.cvSilverSmall.isHidden = self.silversSmall.isEmpty
//
//        self.cvBronzeFull.isHidden = self.bronzesFull.isEmpty
//        self.cvBronzeMid.isHidden = self.bronzesMid.isEmpty
//        self.cvBronzeSmall.isHidden = self.bronzesSmall.isEmpty
        
        let h : CGFloat = 150.0
        self.cvGoldFullHeight.constant = self.goldsFull.isEmpty ? 0 : h
        self.cvGoldMidHeight.constant = self.goldsMid.isEmpty ? 0 : h
        self.cvGoldSmallHeight.constant = self.goldsSmall.isEmpty ? 0 : h
        
        self.cvSilverFullHeight.constant = self.silversFull.isEmpty ? 0 : h
        self.cvSilverMidHeight.constant = self.silversMid.isEmpty ? 0 : h
        self.cvSilverSmallHeight.constant = self.silversSmall.isEmpty ? 0 : h
        
        self.cvBronzeFullHeight.constant = self.bronzesFull.isEmpty ? 0 : h
        self.cvBronzeMidHeight.constant = self.bronzesMid.isEmpty ? 0 : h
        self.cvBronzeSmallHeight.constant = self.bronzesSmall.isEmpty ? 0 : h

        
        
        self.cvGoldFull.reloadData()
        self.cvGoldMid.reloadData()
        self.cvGoldSmall.reloadData()
        
        self.cvSilverFull.reloadData()
        self.cvSilverMid.reloadData()
        self.cvSilverSmall.reloadData()
        
        self.cvBronzeFull.reloadData()
        self.cvBronzeMid.reloadData()
        self.cvBronzeSmall.reloadData()
    }
    
    
}


extension ElanatVC : UICollectionViewDelegate,UICollectionViewDataSource,UICollectionViewDelegateFlowLayout{
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        switch collectionView {
        case cvGoldFull:
            return goldsFull.count
        case cvGoldMid:
            return goldsMid.count
        case cvGoldSmall:
            return goldsSmall.count
        case cvSilverFull:
            return silversFull.count
        case cvSilverMid:
            return silversMid.count
        case cvSilverSmall:
            return silversSmall.count
        case cvBronzeFull:
            return bronzesFull.count
        case cvBronzeMid:
            return bronzesMid.count
        case cvBronzeSmall:
            return bronzesSmall.count
        default:
            return 0
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "cell", for: indexPath) as! ElanCell
        
        switch collectionView {
        case cvGoldFull:
            cell.elan = self.goldsFull[indexPath.item]
        case cvGoldMid:
            cell.elan = self.goldsMid[indexPath.item]
        case cvGoldSmall:
            cell.elan = self.goldsSmall[indexPath.item]
        case cvSilverFull:
            cell.elan = self.silversFull[indexPath.item]
        case cvSilverMid:
            cell.elan = self.silversMid[indexPath.item]
        case cvSilverSmall:
            cell.elan = self.silversSmall[indexPath.item]
        case cvBronzeFull:
            cell.elan = self.bronzesFull[indexPath.item]
        case cvBronzeMid:
            cell.elan = self.bronzesMid[indexPath.item]
        case cvBronzeSmall:
            cell.elan = self.bronzesSmall[indexPath.item]
        default:
            break
        }
        
        print(collectionView.tag)
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        switch collectionView {
        case cvGoldFull:
            return CGSize.init(width: collectionView.frame.width, height: collectionView.frame.height)
        case cvGoldMid:
            return CGSize.init(width: collectionView.frame.width / 2, height: collectionView.frame.height)
        case cvGoldSmall:
            return CGSize.init(width: collectionView.frame.width / 3, height: collectionView.frame.height)
        case cvSilverFull:
            return CGSize.init(width: collectionView.frame.width, height: collectionView.frame.height)
        case cvSilverMid:
            return CGSize.init(width: collectionView.frame.width / 2, height: collectionView.frame.height)
        case cvSilverSmall:
            return CGSize.init(width: collectionView.frame.width / 3, height: collectionView.frame.height)
        case cvBronzeFull:
            return CGSize.init(width: collectionView.frame.width, height: collectionView.frame.height)
        case cvBronzeMid:
            return CGSize.init(width: collectionView.frame.width / 2, height: collectionView.frame.height)
        case cvBronzeSmall:
            return CGSize.init(width: collectionView.frame.width / 3, height: collectionView.frame.height)
        default:
            return CGSize.zero
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        var elan : Elan!
        
        
        switch collectionView {
        case cvGoldFull:
            elan = self.goldsFull[indexPath.row]
        case cvGoldMid:
            elan = self.goldsMid[indexPath.row]
        case cvGoldSmall:
            elan = self.goldsSmall[indexPath.row]
        case cvSilverFull:
            elan = self.silversFull[indexPath.row]
        case cvSilverMid:
            elan = self.silversMid[indexPath.row]
        case cvSilverSmall:
            elan = self.silversSmall[indexPath.row]
        case cvBronzeFull:
            elan = self.bronzesFull[indexPath.row]
        case cvBronzeMid:
            elan = self.bronzesMid[indexPath.row]
        case cvBronzeSmall:
            elan = self.bronzesSmall[indexPath.row]
        default:
            break
        }
        
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "ElanDetailsPopupVC") as! ElanDetailsPopupVC
        vc.modalPresentationStyle = .overCurrentContext
        vc.modalTransitionStyle = .crossDissolve
        vc.elan = elan
        self.present(vc, animated: true, completion: nil)
        
        /*let alert = UIAlertController.init(title: elan.Content, message: nil, preferredStyle: UIAlertController.Style.alert)
        
        if User.isRegistered(){
        alert.addAction(UIAlertAction.init(title: "Get", style: UIAlertAction.Style.default, handler: { (ac) in
            Communication.shared.takeElanRegistered(Elan: elan.ID.stringValue, callback: { (res) in
                self.showErrorMessage(text: "has been sent")
            })
        }))
        }
        
        alert.addAction(UIAlertAction.init(title: "Cancel", style: UIAlertAction.Style.cancel, handler: nil))
        alert.addAction(UIAlertAction.init(title: "Share", style: UIAlertAction.Style.default, handler: { (ac) in
            let imgV = UIImageView()
            Provider.sd_setImage(imgV, urlString: elan.ImageURL)
            guard let imgg = imgV.image else {
                return
            }
            
            let imageToShare = [ imgg ]
            let activityViewController = UIActivityViewController(activityItems: imageToShare, applicationActivities: nil)
            activityViewController.popoverPresentationController?.sourceView = self.view
            activityViewController.excludedActivityTypes = [  ]
            self.present(activityViewController, animated: true, completion: nil)
        }))
        DispatchQueue.main.async {
            self.present(alert, animated: true, completion: nil)
        }*/

        
    }
    
    @IBAction func requestNewAd(){
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "AddNewReqVC") as! AddNewReqVC
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
    
}
