//
//  FavoriteAddressesViewController.swift
//  E-commerce
//
//  Created by juger on 10/2/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import SideMenu
import SwiftyJSON
import Alamofire
import DropDown
import CoreLocation

class FavoriteAddressesViewController: BaseVC ,CLLocationManagerDelegate{

    
    //MARK:- Outlets
    @IBOutlet weak var tableView: UITableView!
    @IBOutlet weak var tableViewHeight: NSLayoutConstraint!
    @IBOutlet weak var addNewAddress: UIButton!
    @IBOutlet weak var countryButton: UIButton!
    @IBOutlet weak var cityButton: UIButton!
    @IBOutlet weak var regionButton: UIButton!
    @IBOutlet weak var doneButton: UIButton!
    @IBOutlet weak var addressesHeight: NSLayoutConstraint!
    @IBOutlet weak var addressTextField: UITextField!
    @IBOutlet weak var contentTextField: UITextField!
    @IBOutlet weak var countryTextField: UITextField!
    @IBOutlet weak var cityTextField: UITextField!
    @IBOutlet weak var regionTextField: UITextField!
    
    //MARK:- Variables
    var subUrl = "\(myAddressesURL)"
    var isGetDataSuccess : Bool = false
    var addressesArray : [JSON] = []
    
    let countryDropDown = DropDown()
    let cityDropDown = DropDown()
    let regionDropDown = DropDown()
    
    let locationManager = CLLocationManager()
    var longitude : Double?
    var latitude : Double?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        tableViewSettings()
        
        //To show the side menu when swipe to left
        SideMenuManager.default.menuAddScreenEdgePanGesturesToPresent(toView: self.view, forMenu: UIRectEdge.left)
        
        //To Add reduis to button
        addRadiusButton()
        
        //addBottom line to TextField
        addBottomLineToTextField()
        
        addressesHeight.constant = 0.0
        
        let params : [String : String] = ["SystemPasscode" : systemPasscode , "Customer" : String(userId!)]
        getDataJson(params: params , i : 0)
        
        
    }
    
    //MARK:- Actions
    @IBAction func regionTapped(_ sender: Any) {
    }
   
    @IBAction func cityTapped(_ sender: Any) {
    }
    @IBAction func countryTapped(_ sender: Any) {
    }
    @IBAction func showSideMenu(_ sender: Any) {
        present(SideMenuManager.default.menuLeftNavigationController!, animated: true, completion: nil)
    }
 
    @IBAction func addNewAddressTapped(_ sender: Any) {
        print("buttons work")
        addressesHeight.constant = 170.0
    }
    
    //MARK:- Functions
    func settingsDropDown()
    {
        countryDropDown.anchorView = countryButton
        countryDropDown.direction = .bottom
        countryDropDown.bottomOffset = CGPoint(x: 0, y:(countryDropDown.anchorView?.plainView.bounds.height)!)
        //  countryDropDown.dataSource = ["Syria","UAE"]
        cityDropDown.anchorView = cityButton
        cityDropDown.direction = .bottom
        cityDropDown.bottomOffset = CGPoint(x: 0, y:(cityDropDown.anchorView?.plainView.bounds.height)!)
        // cityDropDown.dataSource = ["damas" , "Allepo"]
        regionDropDown.anchorView = regionButton
        regionDropDown.direction = .bottom
        regionDropDown.bottomOffset = CGPoint(x: 0, y:(regionDropDown.anchorView?.plainView.bounds.height)!)
        // regionDropDown.dataSource = ["ruken al-Deen"]
    }
    
    
    func getCurrentAddress(){
        // Ask for Authorisation from the User.
        self.locationManager.requestAlwaysAuthorization()
        
        // For use in foreground
        self.locationManager.requestWhenInUseAuthorization()
        
        if CLLocationManager.locationServicesEnabled() {
            locationManager.delegate = self
            locationManager.desiredAccuracy = kCLLocationAccuracyBest
            locationManager.requestWhenInUseAuthorization()
            locationManager.startUpdatingLocation()
        }
        
        //print("loctions : \(longitude)  +  \(latitude)")
        
    }
    // Action triggered on selection
    func addActionToDropDown()
    {
        
        countryDropDown.selectionAction = { [unowned self] (index: Int, item: String) in
            print("Selected item: \(item) at index: \(index)")
            self.countryTextField.text = item
            self.cityTextField.text = "City"
            self.regionTextField.text = "Region"
            self.regionDropDown.dataSource = []
//            self.cities = self.countriesArrayJson[index]["City"].arrayValue
//            var tempCities : [String] = []
//            for i in 0 ..< self.cities.count
//            {
//                tempCities.append(self.cities[i]["Name"].stringValue)
//            }
//            self.cityDropDown.dataSource = tempCities
        }
        
        cityDropDown.selectionAction = { [unowned self] (index: Int, item: String) in
            print("Selected item: \(item) at index: \(index)")
            self.cityTextField.text = item
//            self.regions = self.cities[index]["Region"].arrayValue
//            var tempRegions : [String] = []
//            for i in 0 ..< self.regions.count
//            {
//                tempRegions.append(self.regions[i]["Name"].stringValue)
//                self.regionsID.append(self.regions[i]["ID"].stringValue)
//            }
//            self.regionDropDown.dataSource = tempRegions
        }
        
        regionDropDown.selectionAction = { [unowned self] (index: Int, item: String) in
            print("Selected item: \(item) at index: \(index)")
            self.regionTextField.text = item
//            self.regionID = self.regionsID[index]
        }
        
    }
    
    func locationManager(_ manager: CLLocationManager, didUpdateLocations locations: [CLLocation]) {
        
        let userLocation: CLLocation = locations[0]
        
        let latitudeTemp = userLocation.coordinate.latitude
        
        let longitudeTemp = userLocation.coordinate.longitude
        //print("location : \(latitude) + \(longitude)")
        
        self.latitude = latitudeTemp
        self.longitude = longitudeTemp
        
        if let long = longitude , let lat = latitude {
            showErrorMessage(text: "Getting Address Done")
            print("loctions : \(long)  +  \(lat)")
            self.locationManager.stopUpdatingLocation()
        }else
        {
            showErrorMessage(text: "Getting Address Failed")
        }
        
        
    }
    
    func addBottomLineToTextField()
    {
        countryTextField.setBottomBorder()
        cityTextField.setBottomBorder()
        regionTextField.setBottomBorder()
        addressTextField.setBottomBorder()
        contentTextField.setBottomBorder()
        
    }
    func addRadiusButton()
    {
        addNewAddress.layer.cornerRadius = 12
        addNewAddress.layer.borderWidth = 2
        addNewAddress.layer.borderColor  = UIColor.white.cgColor
        
        doneButton.layer.cornerRadius = 12
        doneButton.layer.borderWidth = 2
        doneButton.layer.borderColor  = UIColor.white.cgColor
    }
    func tableViewSettings()
    {
        tableView.delegate = self
        tableView.dataSource = self
        tableView.tableFooterView = UIView()
        tableView.rowHeight = UITableView.automaticDimension
        tableView.register(UINib(nibName: "FavoriteAddressesTableViewCell", bundle : nil), forCellReuseIdentifier: "FavoriteAddressesCells")
    }
    //get data from Web
    func getDataJson(params : [String : String], i : Int){
        let url : String = BASEURL + subUrl
        showLoading()
        Alamofire.request(url, method: .post, parameters: params).responseJSON { response in
            if response.result.isSuccess {
                
                print("Success")
                let addressesData : JSON = JSON(response.result.value!)
                print("purchaseHistory : \(addressesData)")
                let message = addressesData["ErrorMessage"].stringValue
                if message == "" {
                    self.hideLoading()
                    if i == 0 {//Get My Addresses
                    self.isGetDataSuccess = true
                    self.addressesArray = addressesData["Data"]["Data"].arrayValue
                    }else if i == 0 { // Get Places From the Web
                        
                    }
                    self.tableView.reloadData()
                    
                }else
                {
                    self.hideLoading()
                    self.showErrorMessage(text: message)
                }
                
                
                
            }else {
                
                self.hideLoading()
                print("Failed requset api")
                self.showErrorMessage(text: "Please Check Your Internet Connection")
            }
        }
    }
    
}

extension FavoriteAddressesViewController : UITableViewDelegate , UITableViewDataSource {
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return isGetDataSuccess ? addressesArray.count : 0
    }
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "FavoriteAddressesCells", for: indexPath) as! FavoriteAddressesTableViewCell
        let region = addressesArray[indexPath.row]["Region"].stringValue
        let city = addressesArray[indexPath.row]["City"].stringValue
        let country = addressesArray[indexPath.row]["Country"].stringValue
        let content = addressesArray[indexPath.row]["Content"].stringValue
        let name = addressesArray[indexPath.row]["Name"].stringValue
        cell.addressName.text = name
        cell.city.text = city
        cell.content.text = content
        cell.region.text = region
        cell.country.text = country
        return cell
        
    }
}
