//
//  HomeVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 11/3/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit
import ImageSlideshow
import Alamofire
import AlamofireImage

class HomeVC: BaseVC, UICollectionViewDelegate, UICollectionViewDataSource,UICollectionViewDelegateFlowLayout {
    
    //    @IBOutlet weak var colelctionViewSlider : UICollectionView!
    @IBOutlet weak var colelctionView1 : UICollectionView!
    @IBOutlet weak var colelctionView2 : UICollectionView!
    @IBOutlet weak var colelctionView3 : UICollectionView!
    @IBOutlet weak var colelctionView4 : UICollectionView!
    @IBOutlet weak var colelctionViewToday : UICollectionView!
    @IBOutlet weak var colelctionViewPromotions : UICollectionView!
    @IBOutlet weak var scrol : UIScrollView!
    
    @IBOutlet weak var collectionLbl1 : UIButton!
    @IBOutlet weak var collectionLbl2 : UIButton!
    @IBOutlet weak var collectionLbl3 : UIButton!
    @IBOutlet weak var collectionLbl4 : UIButton!
    
    @IBOutlet weak var sliderShow: ImageSlideshow!
    
    
    var sliders = [SliderItem]()
    var products1 = [ProductHome]()
    var products2 = [ProductHome]()
    var products3 = [ProductHome]()
    var products4 = [ProductHome]()
    var todays = [Today]()
    var promotions = [Promotion]()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.title = "HOME"
        
        setupSideMenu()
        setupLeftButton()
        //        setupRightButtons()
        
        self.scrol.isHidden = true
        getData()
        Communication.shared.locationInfo { (res) in
            Provider.currentLocation = res
        }
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        
        self.setupRightBarButtons()
    }
    
    override func getRefreshing() {
        Communication.shared.slider { (res) in
            self.sliders = res
            
            Communication.shared.homeProducts(callback: { (res) in
                self.products1 = res.count > 0 ? res[0].Products : []
                self.products2 = res.count > 0 ? res[1].Products : []
                self.products3 = res.count > 0 ? res[2].Products : []
                self.products4 = res.count > 0 ? res[3].Products : []
                
//                self.collectionLbl1.setTitle(res[0].Name, for: UIControl.State.normal)
//                self.collectionLbl2.setTitle(res[1].Name, for: UIControl.State.normal)
//                self.collectionLbl3.setTitle(res[2].Name, for: UIControl.State.normal)
//                self.collectionLbl4.setTitle(res[3].Name, for: UIControl.State.normal)
                
                Communication.shared.todayHotDeals(callback: { (res) in
                    self.todays = res
                    
                    Communication.shared.promotion(callback: { (res) in
                        self.hideLoading()
                        self.promotions = res
                        
                        self.scrol.isHidden = false
                        
                        self.refreshData()
                        self.imageSliderSettings()
                    })
                })
            })
        }
    }
    
    
    override func setupViews() {
        //        self.colelctionViewSlider.delegate = self
        //        self.colelctionViewSlider.dataSource = self
        
        self.colelctionView1.delegate = self
        self.colelctionView1.dataSource = self
        
        self.colelctionView2.delegate = self
        self.colelctionView2.dataSource = self
        
        self.colelctionView3.delegate = self
        self.colelctionView3.dataSource = self
        
        self.colelctionView4.delegate = self
        self.colelctionView4.dataSource = self
        
        self.colelctionViewToday.delegate = self
        self.colelctionViewToday.dataSource = self
        
        self.colelctionViewPromotions.delegate = self
        self.colelctionViewPromotions.dataSource = self
        
        //        colelctionViewSlider.register(UINib.init(nibName: "SliderCell", bundle: nil), forCellWithReuseIdentifier: "sliderCell")
        
        colelctionView1.register(UINib.init(nibName: "ProductCell2", bundle: nil), forCellWithReuseIdentifier: "cell")
        colelctionView2.register(UINib.init(nibName: "ProductCell2", bundle: nil), forCellWithReuseIdentifier: "cell")
        colelctionView3.register(UINib.init(nibName: "ProductCell2", bundle: nil), forCellWithReuseIdentifier: "cell")
        colelctionView4.register(UINib.init(nibName: "ProductCell2", bundle: nil), forCellWithReuseIdentifier: "cell")
        colelctionViewToday.register(UINib.init(nibName: "TodayCell", bundle: nil), forCellWithReuseIdentifier: "todayCell")
        colelctionViewPromotions.register(UINib.init(nibName: "PromotionCollectionCell", bundle: nil), forCellWithReuseIdentifier: "promotionCell")
    }
    
    func refreshData(){
        
        //        self.colelctionViewSlider.reloadData()
        
        self.colelctionView1.reloadData()
        self.colelctionView2.reloadData()
        self.colelctionView3.reloadData()
        self.colelctionView4.reloadData()
        
        self.colelctionViewToday.reloadData()
        self.colelctionViewPromotions.reloadData()
    }
    
    func imageSliderSettings()
    {
        sliderShow.slideshowInterval = 5.0
        sliderShow.pageIndicatorPosition = .init(horizontal: .center, vertical: .bottom)
        sliderShow.contentScaleMode = UIView.ContentMode.scaleAspectFit//Fill
        
        
        let pageControl = UIPageControl()
        pageControl.currentPageIndicatorTintColor = UIColor.lightGray
        pageControl.pageIndicatorTintColor = UIColor.black
        sliderShow.pageIndicator = pageControl
        sliderShow.activityIndicator = DefaultActivityIndicator(style: .white, color : .black )
        sliderShow.currentPageChanged = { page in
        }
        
        sliderShow.setImageInputs(self.sliders.map({AlamofireSource.init(urlString: $0.ImageURL)!}))
    }
    
    
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        switch collectionView {
            //        case colelctionViewSlider:
            //            return sliders.count
            
        case colelctionView1:
            return products1.count
        case colelctionView2:
            return products2.count
        case colelctionView3:
            return products3.count
        case colelctionView4:
            return products4.count
        case colelctionViewToday:
            return todays.count
        case colelctionViewPromotions:
            return promotions.count
        default:
            break
        }
        return 0
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        
        
        switch collectionView {
            
        case colelctionView1:
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "cell", for: indexPath) as! ProductCell
            cell.product2 = self.products1[indexPath.row]
            return cell
        case colelctionView2:
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "cell", for: indexPath) as! ProductCell
            cell.product2 = self.products2[indexPath.row]
            return cell
        case colelctionView3:
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "cell", for: indexPath) as! ProductCell
            cell.product2 = self.products3[indexPath.row]
            return cell
        case colelctionView4:
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "cell", for: indexPath) as! ProductCell
            cell.product2 = self.products4[indexPath.row]
            return cell
        case colelctionViewToday:
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "todayCell", for: indexPath) as! TodayCell
            cell.today = self.todays[indexPath.row]
            return cell
        case colelctionViewPromotions:
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "promotionCell", for: indexPath) as! PromotionCollectionCell
            cell.promotion = self.promotions[indexPath.row]
            return cell
        default:
            break
        }
        
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "cell", for: indexPath) as! ProductCell
        return cell
        
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        switch collectionView {
            //        case colelctionViewSlider:
            //            return sliders.count
            
        case colelctionView1:
            return CGSize.init(width: collectionView.bounds.width / 3, height: collectionView.bounds.height)
        case colelctionView2:
            return CGSize.init(width: collectionView.bounds.width / 3, height: collectionView.bounds.height)
        case colelctionView3:
            return CGSize.init(width: collectionView.bounds.width / 3, height: collectionView.bounds.height)
        case colelctionView4:
            return CGSize.init(width: collectionView.bounds.width / 3, height: collectionView.bounds.height)
        case colelctionViewToday:
            return CGSize.init(width: collectionView.bounds.width, height: collectionView.bounds.height)
        case colelctionViewPromotions:
            return CGSize.init(width: collectionView.bounds.width, height: collectionView.bounds.height)
        default:
            break
        }
        return CGSize.zero
    }
    
    
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        switch collectionView {
            
        case colelctionView1:
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductDetailsVC") as! ProductDetailsVC
            vc.productId = self.products1[indexPath.row].ID.stringValue
            self.navigationController?.pushViewController(vc, animated: true)
        case colelctionView2:
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductDetailsVC") as! ProductDetailsVC
            vc.productId = self.products2[indexPath.row].ID.stringValue
            self.navigationController?.pushViewController(vc, animated: true)
        case colelctionView3:
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductDetailsVC") as! ProductDetailsVC
            vc.productId = self.products3[indexPath.row].ID.stringValue
            self.navigationController?.pushViewController(vc, animated: true)
        case colelctionView4:
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductDetailsVC") as! ProductDetailsVC
            vc.productId = self.products4[indexPath.row].ID.stringValue
            self.navigationController?.pushViewController(vc, animated: true)
        case colelctionViewToday:
            //            let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductDetailsVC") as! ProductDetailsVC
            //            vc.product = self.todays[indexPath.item].Product
            //            vc.productId = self.todays[indexPath.item].Product.ID.stringValue
            //            self.navigationController?.pushViewController(vc, animated: true)
            
            
            let alert = UIAlertController.init(title: self.todays[indexPath.item].Content, message: nil, preferredStyle: UIAlertController.Style.alert)
            
            if User.isRegistered(){
                alert.addAction(UIAlertAction.init(title: "Open details", style: UIAlertAction.Style.default, handler: { (ac) in
                    let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductDetailsVC") as! ProductDetailsVC
                    vc.product = self.todays[indexPath.item].Product
                    vc.productId = self.todays[indexPath.item].Product.ID.stringValue
                    self.navigationController?.pushViewController(vc, animated: true)
                }))
            }
            
            alert.addAction(UIAlertAction.init(title: "Cancel", style: UIAlertAction.Style.cancel, handler: nil))
            alert.addAction(UIAlertAction.init(title: "Share", style: UIAlertAction.Style.default, handler: { (ac) in
                let imgV = UIImageView()
                Provider.sd_setImage(imgV, urlString: self.todays[indexPath.item].ImageURL)
                guard let imgg = imgV.image else {
                    return
                }
                
                let imageToShare = [ imgg ]
                let activityViewController = UIActivityViewController(activityItems: imageToShare, applicationActivities: nil)
                activityViewController.popoverPresentationController?.sourceView = self.view
                activityViewController.excludedActivityTypes = [  ]
                self.present(activityViewController, animated: true, completion: nil)
            }))
            DispatchQueue.main.async {
                self.present(alert, animated: true, completion: nil)
            }
            
            
        case colelctionViewPromotions:
            
            let alert = UIAlertController.init(title: "Take promotion?", message: "An Email will be sent to you with the public and private keys of the promotion", preferredStyle: UIAlertController.Style.alert)
            
            alert.addAction(UIAlertAction.init(title: "OK", style: UIAlertAction.Style.default, handler: { (ac) in
                self.showLoading()
                let id = self.promotions[indexPath.row].ID.stringValue
                Communication.shared.takePromotion(Promotion: id, callback: { (res) in
                    self.hideLoading()
                })
            }))
            
            alert.addAction(UIAlertAction.init(title: "Cancel", style: UIAlertAction.Style.cancel, handler: nil))
            
            alert.addAction(UIAlertAction.init(title: "Share", style: UIAlertAction.Style.default, handler: { (ac) in
                
                let imgV = UIImageView()
                
                Provider.sd_setImage(imgV, urlString: self.promotions[indexPath.row].ImageURL)
                
                guard let imgg = imgV.image else {
                    return
                }
                
                let imageToShare = [ imgg ]
                let activityViewController = UIActivityViewController(activityItems: imageToShare, applicationActivities: nil)
                activityViewController.popoverPresentationController?.sourceView = self.view // so that iPads won't crash
                
                activityViewController.excludedActivityTypes = [  ]
                
                self.present(activityViewController, animated: true, completion: nil)
            }))
            
            
            DispatchQueue.main.async {
                self.present(alert, animated: true, completion: nil)
            }
            
        default:
            break
        }
        
    }
    
}


