//
//  HomeViewController.swift
//  E-commerce
//
//  Created by juger on 9/9/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import SideMenu
import ImageSlideshow
import SwiftyJSON
import Alamofire
import AlamofireImage

//ToCheck if the log out or not
var isLogout : Bool = false


class HomeViewController: BaseVC  {

    
    
    //MARK:- Outlets
    @IBOutlet weak var promotionSlideShow: ImageSlideshow!
    @IBOutlet weak var collectionView: UICollectionView!
    @IBOutlet weak var suggestedLabel: UILabel!
    
    //MARK:- Variables & Constant
    let nameOfImages = ["item1","item2","item3","item4"]
    let labelOfItems = [" orange","Elderberry Vit","Tri-3D Omega"," Omega-3 100'S"]
    let subUrl = ""
    var isGetDataSuccess : Bool = false
    var sliders = [SliderItem]()

    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.navigationController?.isNavigationBarHidden = false
        
        print("userID \(String(describing: userId))")
        //settings of sideMenu
        sideSettings()
        
        //imageSlider Settings
//        imageSliderSettings()
        
        //to set the title of back button to ""
        self.navigationItem.backBarButtonItem = UIBarButtonItem(title: "", style: .plain, target: nil, action: nil)
        self.navigationItem.backBarButtonItem?.tintColor = UIColor(red: 0.29, green: 0.29, blue: 0.29, alpha: 1.0)
        collectionView.delegate = self
        collectionView.dataSource = self
        collectionView.register(UINib(nibName : "ItemsCollectionViewCell" , bundle : nil), forCellWithReuseIdentifier: "itemsCells")
        suggestedLabel.attributedText = NSAttributedString(string: "Suggested Products:", attributes:
            [.underlineStyle: NSUnderlineStyle.single.rawValue])
        
        
        Communication.shared.slider { (res) in
            self.sliders = res
            self.imageSliderSettings()
        }
        
    }
    
    //MARK:- Actions
    @IBAction func searchTapped(_ sender: Any) {
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "SearchStoryboard") as! SearchViewController
        self.navigationController?.pushViewController(vc, animated: true)
    }
    @IBAction func cartTapped(_ sender: UIBarButtonItem) {
            let cartStoryboard = UIStoryboard(name: "CartStoryboard", bundle: nil)
            let cartViewController = cartStoryboard.instantiateViewController(withIdentifier: "CartStoryboard") as! CartViewController
            self.navigationController?.pushViewController(cartViewController, animated: true)

    }
    
    @IBAction func categoryTapped(_ sender: Any) {
    }
    
    @IBAction func showSideMenu(_ sender: UIBarButtonItem) {
        present(SideMenuManager.default.menuLeftNavigationController!, animated: true, completion: nil)
    }
    
    
    //MARK:- Functions
    
    func delay(seconds: Double, completion: @escaping ()-> Void) {
        DispatchQueue.main.asyncAfter(deadline: .now() + seconds, execute: completion)
    }
    
    //get data from Web
    func getDataJson(params : [String : String]){
        let url : String = BASEURL + subUrl
        showLoading()
        Alamofire.request(url, method: .post, parameters: params).responseJSON { response in
            if response.result.isSuccess {
                print("Success")
                self.isGetDataSuccess = true
                self.hideLoading()
                
            }else {
                
                self.hideLoading()
                print("Failed requset api")
                self.showErrorMessage(text: "Please CHeck Your Internet Connection")
            }
        }
    }
    
    
    func imageSliderSettings()
    {
        promotionSlideShow.slideshowInterval = 5.0
        promotionSlideShow.pageIndicatorPosition = .init(horizontal: .center, vertical: .bottom)
        promotionSlideShow.contentScaleMode = UIView.ContentMode.scaleAspectFit//Fill
        
        
        let pageControl = UIPageControl()
        pageControl.currentPageIndicatorTintColor = UIColor.lightGray
        pageControl.pageIndicatorTintColor = UIColor.black
        promotionSlideShow.pageIndicator = pageControl
        // optional way to show activity indicator during image load (skipping the line will show no activity indicator)
        promotionSlideShow.activityIndicator = DefaultActivityIndicator(style: .white, color : .black )
        promotionSlideShow.currentPageChanged = { page in
           // print("current page:", page)
        }
        
        
        promotionSlideShow.setImageInputs(self.sliders.map({AlamofireSource.init(urlString: $0.ImageURL)!}))

//        promotionSlideShow.setImageInputs([ImageSource(imageString: "Slider")!,ImageSource(imageString: "Slider")!,ImageSource(imageString: "Slider")!,ImageSource(imageString: "Slider")!])
        

    }
    override var prefersStatusBarHidden: Bool {
        return false
    }
    override func viewWillTransition(to size: CGSize, with coordinator: UIViewControllerTransitionCoordinator) {
        super.viewWillTransition(to: size, with: coordinator)
        
        if UIDevice.current.orientation.isPortrait {
            isLandscape = false
        }else
        {
            isLandscape = true
        }
        
    }
    
    
    //Settings Of SideMenu
    func sideSettings()
    {
        let storyboardNavigationController = UIStoryboard(name: "menuStoryboard", bundle: nil)
        let menuLeftNavigationController = storyboardNavigationController.instantiateViewController(withIdentifier: "menuNavigationController") as! UISideMenuNavigationController
        SideMenuManager.default.menuLeftNavigationController = menuLeftNavigationController
        SideMenuManager.default.menuAddScreenEdgePanGesturesToPresent(toView: self.view, forMenu: UIRectEdge.left)
        
        SideMenuManager.default.menuWidth = UIScreen.main.bounds.width * 2 / 3
        SideMenuManager.default.menuFadeStatusBar = false
        SideMenuManager.default.menuAnimationPresentDuration = 0.3
        SideMenuManager.default.menuAnimationDismissDuration = 0.3
        SideMenuManager.default.menuPresentMode = .menuSlideIn
    }
    
    
    
}

extension HomeViewController: UICollectionViewDelegate,UICollectionViewDataSource,UICollectionViewDelegateFlowLayout {
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return nameOfImages.count
    }
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "itemsCells", for: indexPath) as! ItemsCollectionViewCell
        cell.imageOfProduct.image =  UIImage(named: nameOfImages[indexPath.row])
        cell.nameOfProduct.text = labelOfItems[indexPath.row]
        
        return cell
        
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        
        let size = CGSize.init(width: self.view.frame.width / 2 , height: collectionView.frame.height)
        
        return size
        
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {     
    }
    
}

