//
//  ItemViewerViewController.swift
//  E-commerce
//
//  Created by juger on 8/16/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import ImageSlideshow
import SwiftyJSON
import Alamofire
import SDWebImage

var productAddedToCart : [JSON] = []

class ItemViewerViewController: BaseVC {
    
    //MARK:- Outlets
    @IBOutlet weak var slideShowImage: ImageSlideshow!
    @IBOutlet weak var addToCartButton: UIButton!
    @IBOutlet weak var productPriceLabel: UILabel!
    @IBOutlet weak var productNameLabel: UILabel!
    @IBOutlet weak var priceBeforeSaleLabel: UILabel!
    @IBOutlet weak var contentLabel: UILabel!
    @IBOutlet weak var colorCollectionView: UICollectionView!
    @IBOutlet weak var heightOfColorCollection: NSLayoutConstraint!
    //MARK:- Variables
    var productID : Int = -1
    var subUrl = "\(productURL)"
    var imagesNoColor : [SDWebImageSource] = []
    var imagesColor : [SDWebImageSource] = []

    var productData : JSON!
    var isGetData : Bool = false
    var isColorItemTapped : Bool = false
    
    override func viewDidLoad() {
        super.viewDidLoad()
        colorCollectionView.delegate = self
        colorCollectionView.dataSource = self
        colorCollectionView.register(UINib(nibName: "ColorCollectionViewCell" , bundle : nil), forCellWithReuseIdentifier: "ColorCells")
        
//        slideShowImage.setImageInputs([ImageSource(imageString: "Bitmap")!])
        slideShowImage.contentScaleMode = UIView.ContentMode.scaleAspectFill
        
    //    setButtonsDesign()
        let params : [String : String] = ["SystemPasscode" : systemPasscode , "ID" : String(productID)]
        getDataJson(params: params)

        
        
    }

    
    
    //MARK:- Actions
    @IBAction func NoColorTapped(_ sender: Any) {
        self.slideShowImage.setImageInputs(self.imagesNoColor)
    }
    @IBAction func expandedTapped(_ sender: Any) {
        let fullScreenController = slideShowImage.presentFullScreenController(from: self)
        
        // set the activity indicator for full screen controller (skipping the line will show no activity indicator)
        fullScreenController.slideshow.activityIndicator = DefaultActivityIndicator(style: .white, color: nil)
    }
    @IBAction func addToCartTapped(_ sender: UIButton) {
        productAddedToCart.append(productData)
        showErrorMessage(text: "Add product Done")
        self.navigationController?.popViewController(animated: true)
    }
    
    //MARK:- Functions
    //get data from Web
    func getDataJson(params : [String : String]){
        let url : String = BASEURL + subUrl
        showLoading()
        Alamofire.request(url, method: .post, parameters: params).responseJSON { response in
            if response.result.isSuccess {
                print("Success")
                var itemViewerData : JSON = JSON(response.result.value!)
                self.productData = itemViewerData
                print("itemViewerData : \(itemViewerData)")
                let message = itemViewerData["ErrorMessage"].stringValue
                self.isGetData = true
                if message == ""
                {
                    
                    self.hideLoading()
                    let price = itemViewerData["Data"]["Data"]["Price"].stringValue
                    let priceBeforeSale = itemViewerData["Data"]["Data"]["PriceBeforeSale"].stringValue
                    let name = itemViewerData["Data"]["Data"]["Name"].stringValue
                    let content = itemViewerData["Data"]["Data"]["Content"].stringValue
                    let imagesNoColor = itemViewerData["Data"]["Data"]["Images"]["NoColor"].arrayValue
                    self.productNameLabel.text = name
                    self.productPriceLabel.text = price + "$"
                    self.priceBeforeSaleLabel.text = priceBeforeSale + "$"
                    self.contentLabel.text = content
                    for i in 0 ..< imagesNoColor.count
                    {
                        self.imagesNoColor.append(SDWebImageSource(urlString: imagesNoColor[i].stringValue)!)
                    }
                  self.slideShowImage.setImageInputs(self.imagesNoColor)
                    
                    self.title = itemViewerData["Data"]["Data"]["SKU"].stringValue
                   
                    
                }else
                {
                    self.hideLoading()
                }
                self.colorCollectionView.reloadData()
                //print(self.dataArray[0].id)
            }else {
                
                self.hideLoading()
                print("Failed requset api")
                 self.showErrorMessage(text: "Please Check Your Internet Connection")
            }
        }
    }
    override var prefersStatusBarHidden: Bool {
        return false
    }
    @IBAction func didTap() {
        let fullScreenController = slideShowImage.presentFullScreenController(from: self)
        // set the activity indicator for full screen controller (skipping the line will show no activity indicator)
        //  fullScreenController.preferredContentSize = self.view.frame.size
        fullScreenController.slideshow.activityIndicator = DefaultActivityIndicator(style: .white, color: nil)
        
    }
    
    //make button with bordar
    func setButtonsDesign()
    {
        addToCartButton.layer.cornerRadius = 25
        addToCartButton.layer.borderWidth = 2
        addToCartButton.layer.borderColor  = UIColor.white.cgColor
    }
    
}

extension ItemViewerViewController : UICollectionViewDataSource , UICollectionViewDelegate , UICollectionViewDelegateFlowLayout {
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        if isGetData {
            print("in getSuccess")
            let s = productData["Data"]["Data"]["Images"]["Color"].arrayValue
            //print("s : \(s[index\]["ColorURL"].stringValue)")
            return s.count
        }else {
            print("in")
            return 1
        }

    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        print("in cell for row")
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "ColorCells", for: indexPath) as! ColorCollectionViewCell
        if isGetData {
            print("in the cell ")
            let s = productData["Data"]["Data"]["Images"]["Color"].arrayValue
            print("s : \(s[0]["ColorURL"].stringValue)")
        cell.colorImageView.sd_setImage(with: URL(string: s[indexPath.item]["ColorURL"].stringValue), completed: nil)
        
    }
        return cell
    }
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
     
        let size = CGSize.init(width: 50.0, height: 50.0)
        
        return size
    }
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {

        let imageColorTemp = productData["Data"]["Data"]["Images"]["Color"][indexPath.item]["ProductImages"].arrayValue
        print("imageColor : \(imageColorTemp)")
        for i in 0 ..< imageColorTemp.count
        {
            self.imagesColor.append(SDWebImageSource(urlString: imageColorTemp[i].stringValue)!)
        }
        self.slideShowImage.setImageInputs(self.imagesColor)
        
        }
        

    
    
}
