//
//  MyOrdersVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 10/27/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import SideMenu

class MyOrdersVC: BaseVC, UITableViewDelegate, UITableViewDataSource {

    @IBOutlet weak var tableView : UITableView!
    
    var orders = [Order]()
    
    override func viewDidLoad() {
        super.viewDidLoad()

//        self.setupRightButtons()
        self.setupLeftButton()
        self.setupSideMenu()
        getData()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        
        self.setupRightBarButtons()
    }

    
    override func setupViews() {
        self.title = "My Orders"
        self.tableView.dataSource = self
        self.tableView.delegate = self
        self.tableView.rowHeight = UITableView.automaticDimension
        self.tableView.estimatedRowHeight = 100
        self.tableView.tableFooterView = UIView()
        self.tableView.separatorStyle = .none
        
    }
    
    override func getRefreshing() {
        Communication.shared.getOrders { (res) in
            self.hideLoading()
            
            self.orders = res
            self.tableView.reloadData()
        }
    }
    
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return orders.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "cell", for: indexPath) as! OrderCell
        cell.selectionStyle = .none
        cell.tag = indexPath.row
        cell.parentVC = self
        cell.order = self.orders[indexPath.row]
        
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
    }
    
    
    func openDetails(_ index : Int){
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "OrderDetailsVC") as! OrderDetailsVC
        vc.order = self.orders[index]
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
    func openTrack(_ index : Int){
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "OrderTrackVC") as! OrderTrackVC
        vc.order = self.orders[index]
        self.navigationController?.pushViewController(vc, animated: true)
    }


}
