//
//  MyWishlistVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 10/27/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import SideMenu

class MyWishlistVC: BaseVC, UITableViewDelegate, UITableViewDataSource {
    
    @IBOutlet weak var tableView : UITableView!
    
    var products = [Product]()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
//        self.setupRightButtons()
        self.setupLeftButton()
        self.setupSideMenu()
        
        getData()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        
        self.setupRightBarButtons()
    }

    
    override func setupViews() {
        self.title = "My Wish List"
        self.tableView.dataSource = self
        self.tableView.delegate = self
        self.tableView.rowHeight = UITableView.automaticDimension
        self.tableView.estimatedRowHeight = 100
        self.tableView.tableFooterView = UIView()
        self.tableView.separatorStyle = .none
        
        let menuItem = UIBarButtonItem.init(image: UIImage.init(named: "barButtonItem"), style: UIBarButtonItem.Style.plain, target: self, action: #selector(self.showSideMenu))
        menuItem.tintColor = UIColor.init("333333")
        self.navigationItem.leftBarButtonItem = menuItem
        
        let searchItem = UIBarButtonItem.init(barButtonSystemItem: UIBarButtonItem.SystemItem.search, target: self, action: #selector(self.searchTapped))
        searchItem.tintColor = UIColor.init("333333")
        let cartItem = UIBarButtonItem.init(image: UIImage.init(named: "bag"), style: UIBarButtonItem.Style.plain, target: self, action: #selector(self.cartTapped))
        cartItem.tintColor = UIColor.init("333333")
        
        self.navigationItem.rightBarButtonItems = [searchItem,cartItem]
    }
    
    
    override func getRefreshing() {
        Communication.shared.myWishList { (res) in
            self.hideLoading()
            
            self.products = res
            self.tableView.reloadData()
        }
    }
    
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return products.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "cell", for: indexPath) as! MyWishlistCell
        cell.selectionStyle = .none
        
        cell.tag = indexPath.row
        cell.parentVC = self
        cell.product = self.products[indexPath.row]
        
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let sb = UIStoryboard(name: "ItemViewerStoryboard", bundle: nil)
        let vc = sb.instantiateViewController(withIdentifier: "ItemViewerStoryboard") as! ItemViewerViewController
        vc.productID = self.products[indexPath.row].ID.intValue
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
    func removeAt(_ index : Int){
        let alert = UIAlertController.init(title: "Alert!", message: "Are you sure you want to remove this from wish list?", preferredStyle: UIAlertController.Style.alert)
        
        alert.addAction(UIAlertAction.init(title: "OK", style: UIAlertAction.Style.default, handler: { (ac) in
            self.showLoading()
            Communication.shared.deleteWish(ProductID: self.products[index].ID.stringValue, callback: { (res) in
                self.hideLoading()
                
                self.tableView.beginUpdates()
                self.products.remove(at: index)
                self.tableView.deleteRows(at: [IndexPath.init(row: index, section: 0)], with: UITableView.RowAnimation.fade)
                self.tableView.endUpdates()
            })
        }))
        
        alert.addAction(UIAlertAction.init(title: "Cancel", style: UIAlertAction.Style.cancel, handler: nil))
        self.present(alert, animated: true, completion: nil)
    }
    
    
    
}
