//
//  NotificationViewController.swift
//  E-commerce
//
//  Created by juger on 8/13/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit

class NotificationViewController: BaseVC {

    //MARK:- Outlets
    @IBOutlet weak var imageView: UIImageView!
    @IBOutlet weak var tableView: UITableView!
    @IBOutlet weak var heightOfTableView: NSLayoutConstraint!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()

        tableView.delegate = self
        tableView.dataSource = self
        tableView.register(UINib(nibName: "NotificationTableViewCell",bundle: nil), forCellReuseIdentifier: "notificationCells")
        tableView.estimatedRowHeight = 100.0
        tableView.rowHeight = UITableView.automaticDimension
        
        makeImageViewCircular()
    }
    
    //MARK: - Functions
    override func updateViewConstraints() {
        super.updateViewConstraints()
        heightOfTableView.constant = tableView.contentSize.height
    }
    override var prefersStatusBarHidden: Bool {
        return false
    }
    func makeImageViewCircular()
    {
        imageView.layer.borderWidth = 1.0
        imageView.layer.masksToBounds = false
        imageView.layer.borderColor = UIColor.white.cgColor
        imageView.layer.cornerRadius = imageView.frame.size.height/2
        imageView.clipsToBounds = true
    }


}

extension NotificationViewController: UITableViewDelegate , UITableViewDataSource {
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        heightOfTableView.constant = tableView.contentSize.height
       return 4
    }
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        heightOfTableView.constant = tableView.contentSize.height
        let cell = tableView.dequeueReusableCell(withIdentifier: "notificationCells", for: indexPath) as! NotificationTableViewCell
        return cell
    }
}
