//
//  OrderTrackVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 11/3/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit

class OrderTrackVC: BaseVC,UITableViewDelegate,UITableViewDataSource {

    @IBOutlet weak var tableView : UITableView!
    
    var items = [TrackItem]()
    var order : Order!
    
    override func viewDidLoad() {
        super.viewDidLoad()

        getData()
    }
    
    override func getRefreshing() {
        Communication.shared.track(OrderNumber: order.OrderNumber, AWBNumber: order.AWBNumber) { (res) in
            self.hideLoading()
            
            self.items = res
            self.tableView.reloadData()
        }
    }
    
    override func setupViews() {
        self.tableView.dataSource = self
        self.tableView.delegate = self
        self.tableView.rowHeight = UITableView.automaticDimension
        self.tableView.estimatedRowHeight = 100
        self.tableView.tableFooterView = UIView()
        self.tableView.separatorStyle = .none
        
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return items.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "cell", for: indexPath) as! TrackItemCell
        cell.selectionStyle = .none
        
        cell.trackItem = self.items[indexPath.row]
        return cell
    }
    
    

    

}
