//
//  ProceedPopupVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 11/14/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit

class ProceedPopupVC: BaseVC {

    @IBOutlet weak var vv : UIView!
    @IBOutlet weak var totalLbl : UILabel!
    
    var parentVC : CartVC?

    var products = [String]()
    var QTYs = [Int]()
    var currencyLocation : LocationInfo!
    var publicCode : String!
    var privateCode : String!
    var res = String()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        self.vv.addGestureRecognizer(UITapGestureRecognizer.init(target: self, action: #selector(self.dissmiss)))
        
        totalLbl.text = res + " " + currencyLocation.symbol
    }
    
    @IBAction func proceedAction(){
        
        self.dismiss(animated: true) {
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "CheckOutTVC") as! CheckOutTVC
            vc.products = self.products
            vc.QTYs = self.QTYs
            vc.currencyLocation = self.currencyLocation
            vc.publicCode = self.publicCode
            vc.privateCode = self.privateCode
            vc.res = self.res
            self.parentVC?.navigationController?.pushViewController(vc, animated: true)
        }
        
    }

}
