//
//  ProductDetailsVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 11/3/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit
import ImageSlideshow
import SDWebImage
import SwiftyJSON


class ProductDetailsVC: BaseVC {
    
    @IBOutlet weak var slideShowImage: ImageSlideshow!
    @IBOutlet weak var collectionViewColors: UICollectionView!
    
    @IBOutlet weak var priceLbl: UILabel!
    @IBOutlet weak var priceBeforeLbl: UILabel!
    @IBOutlet weak var nameLbl: UILabel!
    @IBOutlet weak var contentLbl: UILabel!
    
    var productId : String!
    var product : Product!
    var resBase : JSON!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        
        getData()
    }
    
    
    override func getRefreshing() {
        Communication.shared.product(ID: self.productId) { (res,res2) in
            self.hideLoading()
            
            self.product = res
            self.resBase = res2
            
            self.refreshData()
        }
    }
    
    override func setupViews() {
        self.collectionViewColors.delegate = self
        self.collectionViewColors.dataSource = self
        self.collectionViewColors.register(UINib.init(nibName: "ColorCell", bundle: nil), forCellWithReuseIdentifier: "colorCell")
        
        slideShowImage.contentScaleMode = UIView.ContentMode.scaleAspectFill
        
        self.refreshData()
    }
    
    func refreshData(){
        if let product = self.product{
            self.collectionViewColors.reloadData()
            
            var sources = [SDWebImageSource]()
            for i in self.product.Images.NoColor{
                if let s = SDWebImageSource.init(urlString: i){
                    sources.append(s)
                }
            }
            self.slideShowImage.setImageInputs(sources)
            
            self.title = product.SKU
            self.priceLbl.text = product.Price.stringValue + " " + Provider.currentLocation.symbol
            self.nameLbl.text = product.Name
            self.contentLbl.text = product.Content
            self.priceBeforeLbl.isHidden = (product.PriceBeforeSale == nil)
            
            if let PriceBeforeSale = product.PriceBeforeSale{
                let attributedString = NSAttributedString(string: PriceBeforeSale.stringValue + " " + Provider.currentLocation.symbol)
                let textRange = NSMakeRange(0, attributedString.length)
                let underlinedMessage = NSMutableAttributedString(attributedString: attributedString)
                underlinedMessage.addAttribute(NSAttributedString.Key.strikethroughStyle,
                                               value:NSUnderlineStyle.single.rawValue,
                                               range: textRange)
                self.priceBeforeLbl.attributedText = underlinedMessage
            }
        }
    }
    
    @IBAction func fullscreenAction(){
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductImagesVC") as! ProductImagesVC
        vc.product = self.product
        self.present(vc, animated: false, completion: nil)
    }
    
    @IBAction func addToCartTapped(_ sender: UIButton) {
        //        productAddedToCart.append(resBase)
        
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "QuantityVC") as! QuantityVC
        vc.modalPresentationStyle = .overCurrentContext
        vc.modalTransitionStyle = .crossDissolve
        
        vc.product = self.product
        vc.parentVC = self
        
        self.present(vc, animated: true, completion: nil)

        
        /*if let product = self.product{
            let p = CartItem()
            p.ID = self.product.ID.stringValue
            p.Name = self.product.Name
            p.ImageURL = self.product.Images.NoColor.first
            p.Price = self.product.Price.stringValue
            Provider.Cart.append(p)
            showErrorMessage(text: "Add product Done")
            self.navigationController?.popViewController(animated: true)
        }*/
    }
    
}

extension ProductDetailsVC : UICollectionViewDelegate,UICollectionViewDataSource,UICollectionViewDelegateFlowLayout{
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        if let product = self.product{
            if let images = product.Images{
                return images.Color.count + 1
            }
        }
        
        return 1
    }
    
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        
        if indexPath.row == 0{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "cell", for: indexPath) as! ColorCell
            cell.lbl.text = "No Color"
            return cell
        }else{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "colorCell", for: indexPath) as! ColorCell
            cell.color = self.product.Images.Color[indexPath.item - 1]
            return cell
        }
        
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        let w = indexPath.row == 0 ? 100 : 50.0
        return CGSize.init(width: w, height: 50.0)
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        
        var images = [String]()
        
        if indexPath.item == 0{
            images = self.product.Images.NoColor
        }else{
            images = self.product.Images.Color[indexPath.item - 1].ProductImages
        }
        
        var sources = [SDWebImageSource]()
        for i in images{
            if let s = SDWebImageSource.init(urlString: i){
                sources.append(s)
            }
        }
        
        self.slideShowImage.setImageInputs(sources)
    }
    
    
    
    
}
