//
//  ProductImagesVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 11/3/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit
import ImageSlideshow
import SDWebImage

class ProductImagesVC: BaseVC {
    
    @IBOutlet weak var slideShowImage: ImageSlideshow!
    @IBOutlet weak var collectionViewColors: UICollectionView!

    var product : Product!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
    }
    
    override func setupViews() {
        self.collectionViewColors.delegate = self
        self.collectionViewColors.dataSource = self
        self.collectionViewColors.register(UINib.init(nibName: "ColorCell", bundle: nil), forCellWithReuseIdentifier: "colorCell")
        self.collectionViewColors.reloadData()

        var sources = [SDWebImageSource]()
        for i in self.product.Images.NoColor{
            if let s = SDWebImageSource.init(urlString: i){
                sources.append(s)
            }
        }
        self.slideShowImage.setImageInputs(sources)

//        slideShowImage.contentScaleMode = UIView.ContentMode.scaleAspectFill
    }
    
    
    @IBAction func closeAction(){
        self.dismiss(animated: false, completion: nil)
    }
    

}

extension ProductImagesVC : UICollectionViewDelegate,UICollectionViewDataSource,UICollectionViewDelegateFlowLayout{
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        if let product = self.product{
            if let images = product.Images{
                return images.Color.count + 1
            }
        }
        
        return 1
    }
    
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        
        if indexPath.row == 0{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "cell", for: indexPath) as! ColorCell
            cell.lbl.text = "No Color"
            return cell
        }else{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "colorCell", for: indexPath) as! ColorCell
            cell.color = self.product.Images.Color[indexPath.item - 1]
            return cell
        }
        
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        let w = indexPath.row == 0 ? 100 : 50.0
        return CGSize.init(width: w, height: 50.0)
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        
        var images = [String]()
        
        if indexPath.item == 0{
            images = self.product.Images.NoColor
        }else{
            images = self.product.Images.Color[indexPath.item - 1].ProductImages
        }
        
        var sources = [SDWebImageSource]()
        for i in images{
            if let s = SDWebImageSource.init(urlString: i){
                sources.append(s)
            }
        }
        
        self.slideShowImage.setImageInputs(sources)
    }
    
    
}
