//
//  ProfileVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 10/27/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit
import SideMenu

class ProfileVC: BaseVC {

    @IBOutlet weak var img : UIImageView!
    @IBOutlet weak var nameLbl : UILabel!
    @IBOutlet weak var telLbl : UILabel!
    @IBOutlet weak var mobileLbl : UILabel!

    
    override func viewDidLoad() {
        super.viewDidLoad()

        
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        
        self.setupRightBarButtons()
    }

    
    override func setupViews() {
        self.title = "My Profile"

        let me = User.getCurrentUser()
        self.nameLbl.text = me.Fullname
        self.telLbl.text = me.Phone
        self.mobileLbl.text = me.Mobile
        Provider.sd_setImage(self.img, urlString: me.ImageURL)
        
//        self.setupRightButtons()
        self.setupLeftButton()

        self.setupSideMenu()
    }
    

    @IBAction func ChangePasswordAction(){
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "ChangePasswordVC") as! ChangePasswordVC
        vc.modalPresentationStyle = .overCurrentContext
        vc.modalTransitionStyle = .crossDissolve
        self.present(vc, animated: true, completion: nil)
    }
    

}
