//
//  StoreViewController.swift
//  E-commerce
//
//  Created by juger on 8/6/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import SideMenu
class ProfileViewController: BaseVC {

    //MARK:- Outlets
    @IBOutlet weak var heightForProfilePicture: NSLayoutConstraint!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        isRotatedPhone()

        
        //to set the title of back button to ""
        self.navigationItem.backBarButtonItem = UIBarButtonItem(title: "", style: .plain, target: nil, action: nil)
        self.navigationItem.backBarButtonItem?.tintColor = UIColor(red: 0.29, green: 0.29, blue: 0.29, alpha: 1.0)
        //To show the side menu when swipe to left
         SideMenuManager.default.menuAddScreenEdgePanGesturesToPresent(toView: self.view, forMenu: UIRectEdge.left)
        
    }


    //MARK:- Actions
    @IBAction func searchTapped(_ sender: Any) {
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        let vc = storyboard.instantiateViewController(withIdentifier: "SearchStoryboard") as! SearchViewController
        self.navigationController?.pushViewController(vc, animated: true)
    }
    @IBAction func notificationTapped(_ sender: UIBarButtonItem) {
        performSegue(withIdentifier: "goTonotificationSegue", sender: self)
    }
    @IBAction func showSideMenu(_ sender: Any) {
                present(SideMenuManager.default.menuLeftNavigationController!, animated: true, completion: nil)
    }
    
    //MARK:- Functions
    override var prefersStatusBarHidden: Bool {
        return false
    }
    
    override func viewWillAppear(_ animated: Bool) {
        SideMenuManager.default.menuWidth = UIScreen.main.bounds.width * 2 / 3
        isRotatedPhone()
    }
    override func viewWillTransition(to size: CGSize, with coordinator: UIViewControllerTransitionCoordinator) {
        super.viewWillTransition(to: size, with: coordinator)
        if UIDevice.current.orientation.isPortrait {
            isLandscape = false
        }else
        {
            isLandscape = true
        }
        isRotatedPhone()
       
    }
  func isRotatedPhone()
    {
        if isLandscape {
            let newMultiplier:CGFloat = 1.0
            heightForProfilePicture = heightForProfilePicture.setMultiplier(multiplier: newMultiplier)
            //If later in view lifecycle, you may need to call view.layoutIfNeeded()
        }else
        {
            let newMultiplier:CGFloat = 0.3
            heightForProfilePicture = heightForProfilePicture.setMultiplier(multiplier: newMultiplier)
        }
    }
    

}

extension NSLayoutConstraint {
    /**
     Change multiplier constraint
     
     - parameter multiplier: CGFloat
     - returns: NSLayoutConstraint
     */
    func setMultiplier(multiplier:CGFloat) -> NSLayoutConstraint {
        
        NSLayoutConstraint.deactivate([self])
        
        let newConstraint = NSLayoutConstraint(
            item: firstItem!,
            attribute: firstAttribute,
            relatedBy: relation,
            toItem: secondItem,
            attribute: secondAttribute,
            multiplier: multiplier,
            constant: constant)
        
        newConstraint.priority = priority
        newConstraint.shouldBeArchived = self.shouldBeArchived
        newConstraint.identifier = self.identifier
        
        NSLayoutConstraint.activate([newConstraint])
        return newConstraint
    }
}
