//
//  PromotionUseVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 11/14/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit

class PromotionUseVC: BaseVC {

    @IBOutlet weak var vv : UIView!
    @IBOutlet weak var tfPublic : UITextField!
    @IBOutlet weak var tfPrivate : UITextField!

    var parentVC : CartVC?

    var products = [String]()
    var QTYs = [Int]()
    var currencyLocation : LocationInfo!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.vv.addGestureRecognizer(UITapGestureRecognizer.init(target: self, action: #selector(self.dissmiss)))
    }
    
    @IBAction func proceedAction(){
        
        guard let publicCode = self.tfPublic.text,!publicCode.isEmpty,
            let privateCode = self.tfPrivate.text,!privateCode.isEmpty
            else {
                print("Enter public and private code")
            return
        }
        
        self.showLoading()
        Communication.shared.billRegistered(Products: products, QTYs: QTYs, Currency: self.currencyLocation.CurrencyID.stringValue, Private: privateCode, Public: publicCode, Customer: User.getID()) { (res) in
            self.dismiss(animated: true, completion: {
                let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProceedPopupVC") as! ProceedPopupVC
                vc.modalPresentationStyle = .overCurrentContext
                vc.modalTransitionStyle = .crossDissolve
                vc.parentVC = self.parentVC
                vc.products = self.products
                vc.QTYs = self.QTYs
                vc.currencyLocation = self.currencyLocation
                vc.publicCode = publicCode
                vc.privateCode = privateCode
                vc.res = res
                self.parentVC?.present(vc, animated: true, completion: nil)
            })
        }
    }

    
    
}
