//
//  PromotionViewController.swift
//  E-commerce
//
//  Created by juger on 8/6/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import SideMenu
class PromotionViewController: BaseVC {

    override func viewDidLoad() {
        super.viewDidLoad()

        
        //to set the title of back button to ""
        self.navigationItem.backBarButtonItem = UIBarButtonItem(title: "", style: .plain, target: nil, action: nil)
        self.navigationItem.backBarButtonItem?.tintColor = UIColor(red: 0.29, green: 0.29, blue: 0.29, alpha: 1.0)
        //To show the side menu when swipe to left
         SideMenuManager.default.menuAddScreenEdgePanGesturesToPresent(toView: self.view, forMenu: UIRectEdge.left)

    }

    //MARK: - Actions
    @IBAction func searchTapped(_ sender: Any) {
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        let vc = storyboard.instantiateViewController(withIdentifier: "SearchStoryboard") as! SearchViewController
        self.navigationController?.pushViewController(vc, animated: true)
    }
    @IBAction func cartTapped(_ sender: UIBarButtonItem) {
        let cartStoryboard = UIStoryboard(name: "CartStoryboard", bundle: nil)
        let cartViewController = cartStoryboard.instantiateViewController(withIdentifier: "CartStoryboard") as! CartViewController        
        self.navigationController?.pushViewController(cartViewController, animated: true)
        
        
    }
    @IBAction func showSideMenu(_ sender: Any) {
                present(SideMenuManager.default.menuLeftNavigationController!, animated: true, completion: nil)
    }
    
    //MARK:- Functions
    override func viewWillTransition(to size: CGSize, with coordinator: UIViewControllerTransitionCoordinator) {
        super.viewWillTransition(to: size, with: coordinator)
        if UIDevice.current.orientation.isPortrait {
            isLandscape = false
        }else
        {
            isLandscape = true
        }
    }

    override var prefersStatusBarHidden: Bool {
        return false
    }
//    

}
