//
//  PromotionsVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 10/27/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit
import SideMenu

class PromotionsVC: BaseVC, UITableViewDelegate, UITableViewDataSource {
    
    @IBOutlet weak var tableView : UITableView!
    
    var promotions = [Promotion]()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        getData()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        
        self.setupRightBarButtons()
    }
    
    override func setupViews() {
        self.title = "Promotions"
        self.tableView.dataSource = self
        self.tableView.delegate = self
        self.tableView.rowHeight = UITableView.automaticDimension
        self.tableView.estimatedRowHeight = 100
        self.tableView.tableFooterView = UIView()
        self.tableView.separatorStyle = .none
        
        self.setupLeftButton()
        //        self.setupRightButtons()
        setupSideMenu()
    }
    
    override func getRefreshing() {
        Communication.shared.promotion { (res) in
            self.hideLoading()
            
            self.promotions = res
            self.tableView.reloadData()
        }
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return self.promotions.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "cell", for: indexPath) as! PromotionCell
        cell.selectionStyle = .none
        
        cell.tag = indexPath.row
        cell.promotion = self.promotions[indexPath.row]
        
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return tableView.frame.height / 3
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        print("DID SLECT")
        
        let alert = UIAlertController.init(title: "Take promotion?", message: "An Email will be sent to you with the public and private keys of the promotion", preferredStyle: UIAlertController.Style.alert)
        
        if User.isRegistered(){
            alert.addAction(UIAlertAction.init(title: "OK", style: UIAlertAction.Style.default, handler: { (ac) in
                self.showLoading()
                let id = self.promotions[indexPath.row].ID.stringValue
                Communication.shared.takePromotion(Promotion: id, callback: { (res) in
                    self.hideLoading()
                })
            }))
        }
        
        alert.addAction(UIAlertAction.init(title: "Cancel", style: UIAlertAction.Style.cancel, handler: nil))
        
        alert.addAction(UIAlertAction.init(title: "Share", style: UIAlertAction.Style.default, handler: { (ac) in
            
            let imgV = UIImageView()
            
            Provider.sd_setImage(imgV, urlString: self.promotions[indexPath.row].ImageURL)
            
            guard let imgg = imgV.image else {
                return
            }
            
            let imageToShare = [ imgg ]
            let activityViewController = UIActivityViewController(activityItems: imageToShare, applicationActivities: nil)
            activityViewController.popoverPresentationController?.sourceView = self.view // so that iPads won't crash
            
            activityViewController.excludedActivityTypes = [  ]
            
            self.present(activityViewController, animated: true, completion: nil)
        }))
        
        
        DispatchQueue.main.async {
            self.present(alert, animated: true, completion: nil)
        }
    }
    
    
    
    
    
}
