//
//  PurchaseHistoryItemsViewController.swift
//  E-commerce
//
//  Created by juger on 9/6/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import Alamofire
import SwiftyJSON
import SDWebImage



class PurchaseHistoryItemsViewController: BaseVC {

    //MARK:- Outlets 
    @IBOutlet weak var tableView: UITableView!
    @IBOutlet weak var heightTableViewConstraint:NSLayoutConstraint!
    
    
    //MARK:- Variables
    let subUrl = ""
    var isGetDataSuccess : Bool = false
    var invoiceDetails : [JSON] = []
    
    override func viewDidLoad() {
        super.viewDidLoad()
        tableView.delegate = self
        tableView.dataSource = self
        tableView.register(UINib(nibName: "PurchaseHistoryItemsTableViewCell",bundle: nil), forCellReuseIdentifier: "purchaseHistoryItemsCells")

        // Do any additional setup after loading the view.
    }
    
    //MARK:- Actions
    @IBAction func cartTapped(_ sender: Any) {
        let cartStoryboard = UIStoryboard(name: "CartStoryboard", bundle: nil)
        let cartViewController = cartStoryboard.instantiateViewController(withIdentifier: "CartStoryboard") as! CartViewController
        self.navigationController?.pushViewController(cartViewController, animated: true)

    }
    @IBAction func searchTapped(_ sender: Any) {
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "SearchStoryboard") as! SearchViewController
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
    
    //MARK:- Functions
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        heightTableViewConstraint.constant = tableView.contentSize.height
    }
    override func viewWillTransition(to size: CGSize, with coordinator: UIViewControllerTransitionCoordinator) {
        super.viewWillTransition(to: size, with: coordinator)
        if UIDevice.current.orientation.isPortrait {
            isLandscape = false
        }else
        {
            isLandscape = true
        }
        tableView.reloadData()
    }


}
extension PurchaseHistoryItemsViewController: UITableViewDataSource , UITableViewDelegate {
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
    heightTableViewConstraint.constant = tableView.contentSize.height
        return invoiceDetails.count
    }
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        heightTableViewConstraint.constant = tableView.contentSize.height

        let cell = tableView.dequeueReusableCell(withIdentifier: "purchaseHistoryItemsCells", for: indexPath) as! PurchaseHistoryItemsTableViewCell
        let productName = invoiceDetails[indexPath.row]["Product"]["Name"].stringValue
        let totalPrice = invoiceDetails[indexPath.row]["PriceAED"].stringValue
        let productContent = invoiceDetails[indexPath.row]["Product"]["Content"].stringValue
        let productQTY = invoiceDetails[indexPath.row]["QTY"].stringValue
        let imageURL = invoiceDetails[indexPath.row]["Product"]["Images"]["NoColor"][0].stringValue
        cell.productName.text = productName
        cell.totalPrice.text = totalPrice + "$"
        cell.productContent.text = productContent
        cell.productQTY.text = productQTY + " Products"
        cell.selectionStyle = .none
        cell.productImageView.sd_setImage(with: URL(string: imageURL), completed: nil)
        return cell
    }
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        heightTableViewConstraint.constant = tableView.contentSize.height
        
        if !isLandscape {
        return self.view.frame.height / 7.5 
    }else
        {
            return self.view.frame.width / 6.5
        }
    }
    
}
