//
//  PurchaseHistoryViewController.swift
//  E-commerce
//
//  Created by juger on 9/6/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import SideMenu
import Alamofire
import SwiftyJSON


class PurchaseHistoryViewController: BaseVC {
    
    //MARK:- Outlets
    @IBOutlet weak var tableView: UITableView!
    
    
    //MARK:- Variables
    var names = ["Shoes & Bags" , "Glassess" , "Brushes" , "LipStick"]
    let subUrl = "\(ordersURL)"
    var isGetDataSuccess : Bool = false
    var ordersArray : [JSON] = []
    var selectedItemID : Int = -1
    
    override func viewDidLoad() {
        super.viewDidLoad()
        //To show the side menu when swipe to left
        SideMenuManager.default.menuAddScreenEdgePanGesturesToPresent(toView: self.view, forMenu: UIRectEdge.left)
        tableView.delegate = self
        tableView.dataSource = self
        tableView.register(UINib(nibName:"PurchaseTableViewCell", bundle: nil), forCellReuseIdentifier: "purchaseHistoryCells")
        tableView.rowHeight = UITableView.automaticDimension
        
        //to set the title of back button to ""
        self.navigationItem.backBarButtonItem = UIBarButtonItem(title: "", style: .plain, target: nil, action: nil)
        self.navigationItem.backBarButtonItem?.tintColor = UIColor(red: 0.29, green: 0.29, blue: 0.29, alpha: 1.0)
        
        let params : [String : String] = ["SystemPasscode" : systemPasscode , "Customer" : "3"/*String(userId!)*/]
        getDataJson(params: params)
    }
    //MARK:- Actions
    @IBAction func cartTapped(_ sender: Any) {
        let cartStoryboard = UIStoryboard(name: "CartStoryboard", bundle: nil)
        let cartViewController = cartStoryboard.instantiateViewController(withIdentifier: "CartStoryboard") as! CartViewController
        self.navigationController?.pushViewController(cartViewController, animated: true)
        
    }
    @IBAction func searchTapped(_ sender: Any) {
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "SearchStoryboard") as! SearchViewController
        self.navigationController?.pushViewController(vc, animated: true)
    }
    @IBAction func showSideMenu(_ sender: Any) {
        present(SideMenuManager.default.menuLeftNavigationController!, animated: true, completion: nil)
    }
    
    //MARK:- Functions
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        if segue.identifier == "goToPurchaseItemSegue" {
            let vcDes = segue.destination as! PurchaseHistoryItemsViewController
            vcDes.invoiceDetails = ordersArray[selectedItemID]["InvoiceDetails"].arrayValue
            
        }
    }
    //get data from Web
    func getDataJson(params : [String : String]){
        let url : String = BASEURL + subUrl
        showLoading()
        Alamofire.request(url, method: .post, parameters: params).responseJSON { response in
            if response.result.isSuccess {
                
                print("Success")
                let purchaseHistory : JSON = JSON(response.result.value!)
                print("purchaseHistory : \(purchaseHistory)")
                let message = purchaseHistory["ErrorMessage"].stringValue
                if message == "" {
                    self.hideLoading()
                    self.isGetDataSuccess = true
                    self.ordersArray = purchaseHistory["Data"]["Data"].arrayValue
                    self.tableView.reloadData()
                    
                }else
                {
                    self.hideLoading()
                    self.showErrorMessage(text: message)
                }
                
                
                
            }else {
                
                self.hideLoading()
                print("Failed requset api")
                self.showErrorMessage(text: "Please Check Your Internet Connection")
            }
        }
    }
    
    
}

extension PurchaseHistoryViewController: UITableViewDelegate , UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        
        return isGetDataSuccess ? ordersArray.count : 0
    }
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "purchaseHistoryCells", for: indexPath) as! PurchaseTableViewCell
        if isGetDataSuccess {
            cell.address.text = ordersArray[indexPath.row]["Address"].stringValue
            cell.status.text = ordersArray[indexPath.row]["Status"].stringValue
        }
        cell.selectionStyle = .none
        
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        selectedItemID = indexPath.row
        performSegue(withIdentifier: "goToPurchaseItemSegue", sender: self)
    }
}
