//
//  QuantityVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 11/14/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit

class QuantityVC: BaseVC,UIPickerViewDelegate,UIPickerViewDataSource {
    
    
    @IBOutlet weak var vv : UIView!
    @IBOutlet weak var picker : UIPickerView!

    var parentVC : ProductDetailsVC?
    var product : Product!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.vv.addGestureRecognizer(UITapGestureRecognizer.init(target: self, action: #selector(self.dissmiss)))
        
        picker.delegate = self
        picker.dataSource = self
    }
    
    
    @IBAction func addToCartAction(){
        if let product = self.product{
            let p = CartItem()
            p.ID = product.ID.stringValue
            p.Name = product.Name
            p.ImageURL = product.Images.NoColor.first
            p.Price = product.Price.stringValue
            p.QTY = self.picker.selectedRow(inComponent: 0) + 1
            Provider.Cart.append(p)
            showErrorMessage(text: "Done")
            self.dismiss(animated: true) {
                self.parentVC?.navigationController?.popViewController(animated: true)
            }
        }
    }
    
    
    func numberOfComponents(in pickerView: UIPickerView) -> Int {
        return  1
    }
    
    func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        return 100
    }
    
    func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String? {
        return "\(row + 1)"
    }
    
    
    
}
