//
//  QuickCheckoutViewController.swift
//  E-commerce
//
//  Created by juger on 8/12/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import SwiftyJSON
import Alamofire
import DropDown
import SideMenu
import CoreLocation

class QuickCheckoutViewController: BaseVC , CLLocationManagerDelegate{
    
    
    
    //MARK:- Outlets
    @IBOutlet weak var placeOrderButton: UIButton!
    @IBOutlet weak var fullNameTextField: UITextField!
    @IBOutlet weak var publicPromotionIDTextField: UITextField!
    @IBOutlet weak var privatePromotionIDTextField: UITextField!
    @IBOutlet weak var phoneNumberTextField: UITextField!
    @IBOutlet weak var addressTextField: UITextField!
    @IBOutlet weak var countryTextField: UITextField!
    @IBOutlet weak var cityTextField: UITextField!
    @IBOutlet weak var regionTextField: UITextField!
    @IBOutlet weak var totalPriceLabel: UILabel!
    @IBOutlet weak var mobileNumberTextField: UITextField!
    @IBOutlet weak var chooseAddressTextField: UITextField!
    @IBOutlet weak var favoriteAddTF: UITextField!
    @IBOutlet weak var phoneNumStackView: UIStackView!
    @IBOutlet weak var mobileNumStackView: UIStackView!
    @IBOutlet weak var fullNameStackView: UIStackView!
    @IBOutlet weak var countryButton: UIButton!
    @IBOutlet weak var cityButton: UIButton!
    @IBOutlet weak var regionButton: UIButton!
    @IBOutlet weak var chooseAddressButton: UIButton!
    @IBOutlet weak var favoriteAddBu: UIButton!
    @IBOutlet weak var publicPromotionStack: UIStackView!
    @IBOutlet weak var privatePromotionStack: UIStackView!
    @IBOutlet weak var addressStackView: UIStackView!
    @IBOutlet weak var infoAddressTFStack: UIStackView!
    @IBOutlet weak var infoAddressBuStack: UIStackView!
    
    //MARK:- Variables
    var isGetDataSuccess : Bool = false
    
    
    let countryDropDown = DropDown()
    let cityDropDown = DropDown()
    let regionDropDown = DropDown()
    
    let chooseAddressDropDown = DropDown()
    
    
    var countriesArrayJson : [JSON] = []
    var cities : [JSON] = []
    var regions : [JSON] = []
    
    var subUrl = "place/"
    var regionID : String = ""
    var regionsID : [String] = []
    
    
    var productsID : [String] = []
    var QTYS : [String] = []
    var currencyID : Int = -1
    
    let locationManager = CLLocationManager()
    var longitude : Double?
    var latitude : Double?
    
    var witchAddressUserSelect : Int = -1 //if 0 mean geoLocation , 1 mean favorite , 2 manualy if userLoggedIn , else if 0 mean geoLocation  , 1 mean manualy
    


    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        print("currency ID")
        
        //ADD underLine to textField
        setBottomLineToTextField()
        
        callDataJSON()
        hideTextFields()
        
        placeOrderButton.makeButtonWithRadius()
        settingsDropDown()
        
        addActionToDropDown()
        
        
        print("ProductsID \(productsID)")
    }
    
    
    
    //MARK:- Actions
    @IBAction func placeOrderTapped(_ sender: Any) {
        subUrl = "\(orderURL)"
        let addressText = addressTextField.text
        if userLoggedIn {
            print("user logged in ")
            print("prod \(productsID)")
            print("qtys : \(QTYS)")
            switch witchAddressUserSelect {
            case 0:
                if let long = longitude , let lat = latitude {
                    if currencyID != -1 {
                        var params : [String : Any] = ["SystemPasscode" : systemPasscode,"Address" : " " ,"Customer" : userId!,"PublicPromotionID" : publicPromotionIDTextField.text!, "PrivatePromotionID" : privatePromotionIDTextField.text!,"Lat" : lat , "Lon" : long, "Products" : productsID , "QTYs" : QTYS , "Currency": currencyID]
                        if let arr = JSON(productsID).rawString(){
                            params["Products"] = arr
                        }
                        if let arr2 = JSON(QTYS).rawString(){
                            params["QTYs"] = arr2
                        }
                        getDataJson(params: params, i: 2)
                    }else
                    {
                        showErrorMessage(text: "Please Fill The Data")
                    }
                }else
                {
                    showErrorMessage(text: "There is An Error with your Location ")
                }
            case 1:
                print("")
                case 2:
                print("")
                
                if !(addressText?.isEmpty)! && regionID != ""{
                    var params : [String : Any] = ["SystemPasscode" : systemPasscode,"Address" : addressText!,"Customer" : userId!,"PublicPromotionID" : publicPromotionIDTextField.text!, "PrivatePromotionID" : privatePromotionIDTextField.text! ,"RegionID" : regionID , "Products" : productsID , "QTYs" : QTYS , "Currency": currencyID]
                    if let arr = JSON(productsID).rawString(){
                        params["Products"] = arr
                    }
                    if let arr2 = JSON(QTYS).rawString(){
                        params["QTYs"] = arr2
                    }
                    getDataJson(params: params, i: 2)
                }else {
                    showErrorMessage(text: "Please fill the Data")
                }
                
            default:
                showErrorMessage(text: "Please fill Data ")
                break
                
            
            }
            
        } else
        {
            print("user not logged in ")
            let fullName = fullNameTextField.text
            let phone = phoneNumberTextField.text
            let mobile = mobileNumberTextField.text
            
            switch (witchAddressUserSelect) {
            case 0:
                if let long = longitude , let lat = latitude {
                    if !(fullName?.isEmpty)! && !(phone?.isEmpty)! && !(mobile?.isEmpty)! {
                        var params : [String : Any] = ["SystemPasscode" : systemPasscode,"Address" : " " ,"Lat" : lat , "Lon" : long,"OutName" : fullName! , "OutPhone" : phone! , "OutMobile" : mobile! , "Products" : productsID , "QTYs" : QTYS , "Currency": currencyID]
                        if let arr = JSON(productsID).rawString(){
                            params["Products"] = arr
                        }
                        if let arr2 = JSON(QTYS).rawString(){
                            params["QTYs"] = arr2
                        }
                        getDataJson(params: params, i: 2)
                    }else {
                        showErrorMessage(text: "Please fill the Data")
                    }
                }else
                {
                    showErrorMessage(text: "There is An Error with your Location ")
                }
                
            case 1:

                
                if !(addressText?.isEmpty)! && !(fullName?.isEmpty)! && !(phone?.isEmpty)! && !(mobile?.isEmpty)! {
                    var params : [String : Any] = ["SystemPasscode" : systemPasscode,"Address" : addressText! ,"RegionID" : regionID , "OutName" : fullName! , "OutPhone" : phone! , "OutMobile" : mobile! , "Products" : productsID , "QTYs" : QTYS , "Currency": currencyID]
                    if let arr = JSON(productsID).rawString(){
                        params["Products"] = arr
                    }
                    if let arr2 = JSON(QTYS).rawString(){
                        params["QTYs"] = arr2
                    }
                    getDataJson(params: params, i: 2)
                }else {
                    showErrorMessage(text: "Please fill the Data")
                }
                
            default:
                showErrorMessage(text: "Please fill Data")
                break
                
            }

            
            
    
        }
        
    }
    @IBAction func favoriteAddTapped(_ sender: Any) {
    }
    @IBAction func chooseAddressTapped(_ sender: Any) {
        chooseAddressDropDown.show()
    }
    @IBAction func countryTapped(_ sender: Any) {
        countryDropDown.show()
    }
    @IBAction func cityTapped(_ sender: Any) {
        cityDropDown.show()
    }
    @IBAction func regionTapped(_ sender: Any) {
        regionDropDown.show()
    }
    
    
    
    //MARK:- Functions
    // Action triggered on selection
    func addActionToDropDown()
    {
        
        countryDropDown.selectionAction = { [unowned self] (index: Int, item: String) in
            print("Selected item: \(item) at index: \(index)")
            self.countryTextField.text = item
            self.cityTextField.text = "City"
            self.regionTextField.text = "Region"
            self.regionDropDown.dataSource = []
            self.cities = self.countriesArrayJson[index]["City"].arrayValue
            var tempCities : [String] = []
            for i in 0 ..< self.cities.count
            {
                tempCities.append(self.cities[i]["Name"].stringValue)
            }
            self.cityDropDown.dataSource = tempCities
        }
        
        cityDropDown.selectionAction = { [unowned self] (index: Int, item: String) in
            print("Selected item: \(item) at index: \(index)")
            self.cityTextField.text = item
            self.regions = self.cities[index]["Region"].arrayValue
            var tempRegions : [String] = []
            for i in 0 ..< self.regions.count
            {
                tempRegions.append(self.regions[i]["Name"].stringValue)
                self.regionsID.append(self.regions[i]["ID"].stringValue)
            }
            self.regionDropDown.dataSource = tempRegions
        }
        
        regionDropDown.selectionAction = { [unowned self] (index: Int, item: String) in
            print("Selected item: \(item) at index: \(index)")
            self.regionTextField.text = item
            self.regionID = self.regionsID[index]
        }
        chooseAddressDropDown.selectionAction = { [unowned self] (index: Int, item: String) in
            print("Selected item: \(item) at index: \(index)")
            self.chooseAddressTextField.text = item
            self.witchAddressUserSelect = index
            if userLoggedIn {
                if index == 0
                {
                    self.hideInformationAddress()
                    self.hideFavoriteAddresses()
                    self.getCurrentAddress()
                }else if index == 1 {
                    self.hideInformationAddress()
                    self.showFavoriteAddresses()
                }else
                {
                    self.hideFavoriteAddresses()
                    self.showInformationAddress()
                }
            }else
            {
                if index == 0
                {
                   self.hideInformationAddress()
                    self.getCurrentAddress()
                    
                }else if index == 1 {
                   self.showInformationAddress()
                }
            }
            
        }
        
    }

    func locationManager(_ manager: CLLocationManager, didUpdateLocations locations: [CLLocation]) {
        
        let userLocation: CLLocation = locations[0]
        
        let latitudeTemp = userLocation.coordinate.latitude
        
        let longitudeTemp = userLocation.coordinate.longitude
       //print("location : \(latitude) + \(longitude)")
        
        self.latitude = latitudeTemp
        self.longitude = longitudeTemp
        
        if let long = longitude , let lat = latitude {
            showErrorMessage(text: "Getting Address Done")
            print("loctions : \(long)  +  \(lat)")
            self.locationManager.stopUpdatingLocation()
        }else
        {
            showErrorMessage(text: "Getting Address Failed")
        }
        
        
    }
    func getCurrentAddress(){
        // Ask for Authorisation from the User.
        self.locationManager.requestAlwaysAuthorization()
        
        // For use in foreground
        self.locationManager.requestWhenInUseAuthorization()
        
        if CLLocationManager.locationServicesEnabled() {
            locationManager.delegate = self
            locationManager.desiredAccuracy = kCLLocationAccuracyBest
            locationManager.requestWhenInUseAuthorization()
            locationManager.startUpdatingLocation()
        }

        //print("loctions : \(longitude)  +  \(latitude)")
        
    }
    func hideFavoriteAddresses()
    {
        favoriteAddBu.isHidden = true
        favoriteAddTF.isHidden = true
    }
    func showFavoriteAddresses()
    {
        favoriteAddBu.isHidden = false
        favoriteAddTF.isHidden = false
    }
    func hideInformationAddress()
    {

        addressStackView.isHidden = true
        infoAddressTFStack.isHidden = true
        infoAddressBuStack.isHidden = true
        
    }
    func showInformationAddress()
    {
        addressStackView.isHidden = false
        infoAddressTFStack.isHidden = false
        infoAddressBuStack.isHidden = false
    }
    func hideTextFields()
    {

        hideInformationAddress()
        hideFavoriteAddresses()
        if userLoggedIn {
            
            phoneNumStackView.isHidden = true
            mobileNumStackView.isHidden = true
            fullNameStackView.isHidden = true
            
        }else
        {
            publicPromotionStack.isHidden = true
            privatePromotionStack.isHidden = true
        }
    }
    
    //Settings Of DropDown
    func settingsDropDown()
    {
        countryDropDown.anchorView = countryButton
        countryDropDown.direction = .bottom
        countryDropDown.bottomOffset = CGPoint(x: 0, y:(countryDropDown.anchorView?.plainView.bounds.height)!)
        //  countryDropDown.dataSource = ["Syria","UAE"]
        cityDropDown.anchorView = cityButton
        cityDropDown.direction = .bottom
        cityDropDown.bottomOffset = CGPoint(x: 0, y:(cityDropDown.anchorView?.plainView.bounds.height)!)
        // cityDropDown.dataSource = ["damas" , "Allepo"]
        regionDropDown.anchorView = regionButton
        regionDropDown.direction = .bottom
        regionDropDown.bottomOffset = CGPoint(x: 0, y:(regionDropDown.anchorView?.plainView.bounds.height)!)
        // regionDropDown.dataSource = ["ruken al-Deen"]
        chooseAddressDropDown.anchorView = chooseAddressButton
        chooseAddressDropDown.direction = .bottom
        chooseAddressDropDown.bottomOffset = CGPoint(x: 0, y:(chooseAddressDropDown.anchorView?.plainView.bounds.height)!)
        chooseAddressDropDown.dataSource = userLoggedIn ? ["Get Your Current Address","From Favorite Adresses" , "Manualy"] : ["Get Your Current Address", "Manualy"]
    }
    
    func callDataJSON(){
        subUrl = "\(placeURL)"
        let params : [String : String] = ["SystemPasscode" : systemPasscode]
        getDataJson(params: params, i: 0)
        
    }
    //ADD underLine to textField
    func setBottomLineToTextField()
    {
        fullNameTextField.setBottomBorder()
        publicPromotionIDTextField.setBottomBorder()
        privatePromotionIDTextField.setBottomBorder()
        phoneNumberTextField.setBottomBorder()
        addressTextField.setBottomBorder()
        countryTextField.setBottomBorder()
        cityTextField.setBottomBorder()
        regionTextField.setBottomBorder()
        mobileNumberTextField.setBottomBorder()
        chooseAddressTextField.setBottomBorder()
    }
    
    override var prefersStatusBarHidden: Bool {
        return false
    }
    //get data from Web
    func getDataJson(params : [String : Any] , i : Int){
        let url : String = BASEURL + subUrl
        showLoading()
        Alamofire.request(url, method: .post, parameters: params).responseJSON { response in
            if response.result.isSuccess {
                print("Success")
                var dataJson : JSON = JSON(response.result.value!)
                let message = dataJson["ErrorMessage"].stringValue
                print(dataJson)
                
                if message == "" {
                    //To get the places
                    if i == 0 {
                        self.countriesArrayJson = dataJson["Data"]["Data"].arrayValue
                        var countries : [String] = []
                        for i in 0 ..< self.countriesArrayJson.count {
                            countries.append(self.countriesArrayJson[i]["Name"].stringValue)
                        }
                        self.countryDropDown.dataSource = countries
                        self.hideLoading()
                        
                       
                        
                    }else if i == 2 { // To set the Order 
                        print("dataJsonplaceOrder : \(dataJson)")
                        self.showErrorMessage(text: "Your order has placed")
                        productsStackContent.removeAll()
                        catStackContent.removeAll()
                        self.navigationController?.popToRootViewController(animated: true)
                        self.hideLoading()
                    }
                    
                    self.isGetDataSuccess = true
                    
                }else
                {
                    self.hideLoading()
                    self.showErrorMessage(text: message)
                }
            }else {
                
                self.hideLoading()
                print("Failed requset api")
                self.showErrorMessage(text: "Please Check Your Internet Connection")
            }
        }
    }
    
    
}


