//
//  SearchVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 11/3/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit
import SwiftyJSON
import Alamofire
import SDWebImage

class SearchVC: BaseVC, UICollectionViewDelegate,UICollectionViewDataSource,UICollectionViewDelegateFlowLayout {

    @IBOutlet weak var collectionView: UICollectionView!

    var products = [Product]()
    
    override func viewDidLoad() {
        super.viewDidLoad()

    }
    
    override func setupViews() {
        collectionView.delegate = self
        collectionView.dataSource = self
        collectionView.register(UINib(nibName : "ProductCell" , bundle : nil), forCellWithReuseIdentifier: "productCell")
        
        setupSearchBar()
    }
    
    func setupSearchBar()
    {
        let searchBar = UISearchBar()
        searchBar.showsCancelButton = false
        searchBar.placeholder = "Enter your search here!"
        searchBar.delegate = self
        self.navigationItem.titleView = searchBar
    }
    func searchBar(_ searchBar: UISearchBar, textDidChange searchText: String) {
        Communication.shared.search(Text: searchText) { (res) in
            self.products = res
            self.collectionView.reloadData()
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return self.products.count
    }

    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "productCell", for: indexPath) as! ProductCell
        cell.tag = indexPath.row
        cell.product = self.products[indexPath.row]
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        let height = self.view.bounds.height / 2
        let width = self.view.bounds.width / 2
        return CGSize.init(width: width, height: height)
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductDetailsVC") as! ProductDetailsVC
        vc.productId = self.products[indexPath.row].ID.stringValue
        vc.product = self.products[indexPath.row]
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
}
