//
//  SearchViewController.swift
//  E-commerce
//
//  Created by juger on 9/24/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import SwiftyJSON
import Alamofire
import SDWebImage


class SearchViewController: BaseVC {

    //MARK:- Outlets
    @IBOutlet weak var collectionView: UICollectionView!
    
    //MARK:- Variables
    let subUrl = "\(searchURL)"
    var isGetDataSuccess : Bool = false
    var productItems : [JSON] = []
    override func viewDidLoad() {
        super.viewDidLoad()
        
        collectionView.delegate = self
        collectionView.dataSource = self
        collectionView.register(UINib(nibName : "ItemsCollectionViewCell" , bundle : nil), forCellWithReuseIdentifier: "itemsCells")
        collectionView.register(UINib(nibName : "ProductCell" , bundle : nil), forCellWithReuseIdentifier: "ProductCell")


        createSearchBar()
        
    }

    //MARK:- Functions
    //get data from Web
    func getDataJson(params : [String : String]){
        
        
        let url : String = BASEURL + subUrl
       // showLoading()
        Alamofire.request(url, method: .post, parameters: params).responseJSON { response in
            if response.result.isSuccess {
                
                print("Success")
                var allSearchDataJson : JSON = JSON(response.result.value!)
                let message = allSearchDataJson["Data"]["ErrorMessage"].stringValue
                print(allSearchDataJson)
                self.productItems = allSearchDataJson["Data"]["Data"].arrayValue
                if message == "" {
                    print("Success")
                    self.isGetDataSuccess = true
                    self.collectionView.reloadData()
                }else
                {
                    self.hideLoading()
                    self.showErrorMessage(text: message)
                }
                
            }else {
                
                self.hideLoading()
                print("Failed requset api")
                self.showErrorMessage(text: "Please Check Your Internet Connection")
            }
        }
    }
    override func viewWillTransition(to size: CGSize, with coordinator: UIViewControllerTransitionCoordinator) {
        super.viewWillTransition(to: size, with: coordinator)
        
        if UIDevice.current.orientation.isPortrait {
            isLandscape = false
        }else
        {
            isLandscape = true
        }
        collectionView.reloadData()
        
    }
    override var prefersStatusBarHidden: Bool {
        return false
    }
    func createSearchBar()
    {
        let searchBar = UISearchBar()
        searchBar.showsCancelButton = false
        searchBar.placeholder = "Enter your search here!"
        searchBar.delegate = self
        self.navigationItem.titleView = searchBar
    }
    func searchBar(_ searchBar: UISearchBar, textDidChange searchText: String) {
        print("searchText \(searchText)")
        let params : [String : String] = ["SystemPasscode" : systemPasscode , "Text" : searchText]
        getDataJson(params: params)
    }

}
extension SearchViewController: UICollectionViewDelegate , UICollectionViewDataSource , UICollectionViewDelegateFlowLayout{
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        if isGetDataSuccess {
            print("products count \(productItems.count)")
            return productItems.count
        }
        return 0    
    }
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
         let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "itemsCells", for: indexPath) as! ItemsCollectionViewCell
        if isGetDataSuccess {
        let temp = productItems
        cell.imageOfProduct.sd_setImage(with: URL(string: temp[indexPath.item]["Images"]["NoColor"][0].stringValue), completed: nil)
        cell.nameOfProduct.text = temp[indexPath.item]["Name"].stringValue
        cell.productID = temp[indexPath.item]["ID"].intValue
        cell.priceOfProduct.text = temp[indexPath.item]["Price"].stringValue + "$"
        }
        return cell
        
    }
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        let sizePortrait = CGSize.init(width: self.view.frame.width / 2 , height: self.view.frame.height / 2.3 )
        let sizeLandscape = CGSize.init(width: self.view.frame.width / 2 , height: self.view.frame.width / 2.3 )
        if UIDevice.current.orientation.isLandscape || isLandscape {
            return sizeLandscape
        }else {
            return sizePortrait
        }
    }
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        let sb = UIStoryboard(name: "ItemViewerStoryboard", bundle: nil)
        let vc = sb.instantiateViewController(withIdentifier: "ItemViewerStoryboard") as! ItemViewerViewController
        vc.productID = productItems[indexPath.item]["ID"].intValue
        self.navigationItem.backBarButtonItem = UIBarButtonItem(title: "", style: .plain, target: nil, action: nil)
        self.navigationItem.backBarButtonItem?.tintColor = UIColor(red: 0.29, green: 0.29, blue: 0.29, alpha: 1.0)
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
}
