//
//  TodayVC.swift
//  E-commerce
//
//  Created by Yahya Tabba on 11/3/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import UIKit

class TodayVC: BaseVC, UICollectionViewDelegate, UICollectionViewDataSource,UICollectionViewDelegateFlowLayout {

    @IBOutlet weak var collectionView : UICollectionView!
    
    var todays = [Today]()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        self.title = "Today's Hot Deals"
        
//        self.setupRightButtons()
        self.setupLeftButton()
        self.setupSideMenu()

        getData()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        
        self.setupRightBarButtons()
    }

    
    override func getRefreshing() {
        Communication.shared.todayHotDeals { (res) in
            self.hideLoading()
            
            self.todays = res
            self.collectionView.reloadData()
        }
    }
    
    override func setupViews() {
        collectionView.delegate = self
        collectionView.dataSource = self
        collectionView.register(UINib.init(nibName: "TodayCell", bundle: nil), forCellWithReuseIdentifier: "cell")
    }
    
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return todays.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "cell", for: indexPath) as! TodayCell
        cell.today = self.todays[indexPath.item]
        return cell
    }
    
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        return CGSize.init(width: collectionView.bounds.width, height: 150)
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
//        let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductDetailsVC") as! ProductDetailsVC
//        vc.product = self.todays[indexPath.item].Product
//        vc.productId = self.todays[indexPath.item].Product.ID.stringValue
//        self.navigationController?.pushViewController(vc, animated: true)
        let alert = UIAlertController.init(title: self.todays[indexPath.item].Content, message: nil, preferredStyle: UIAlertController.Style.alert)
        alert.addAction(UIAlertAction.init(title: "Open details", style: UIAlertAction.Style.default, handler: { (ac) in
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductDetailsVC") as! ProductDetailsVC
            vc.product = self.todays[indexPath.item].Product
            vc.productId = self.todays[indexPath.item].Product.ID.stringValue
            self.navigationController?.pushViewController(vc, animated: true)
        }))
        alert.addAction(UIAlertAction.init(title: "Cancel", style: UIAlertAction.Style.cancel, handler: nil))
        alert.addAction(UIAlertAction.init(title: "Share", style: UIAlertAction.Style.default, handler: { (ac) in
            let imgV = UIImageView()
            Provider.sd_setImage(imgV, urlString: self.todays[indexPath.item].ImageURL)
            guard let imgg = imgV.image else {
                return
            }
            
            let imageToShare = [ imgg ]
            let activityViewController = UIActivityViewController(activityItems: imageToShare, applicationActivities: nil)
            activityViewController.popoverPresentationController?.sourceView = self.view
            activityViewController.excludedActivityTypes = [  ]
            self.present(activityViewController, animated: true, completion: nil)
        }))
        DispatchQueue.main.async {
            self.present(alert, animated: true, completion: nil)
        }

    }
    
}
