//
//  WishListViewController.swift
//  E-commerce
//
//  Created by juger on 9/6/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import SideMenu
import Alamofire
import SwiftyJSON
import SDWebImage


class WishListViewController: BaseVC {
    
    //MARK;- Outlets
    @IBOutlet weak var tableView: UITableView!
    
    //MARK:- Variables
    var subUrl = "\(myWishURL)"
    var isGetDataSuccess : Bool = false
    var names = ["1","1","1","1","1"]
    var wishListDataJSON : [JSON] = []
    
    
    override func viewDidLoad() {
        super.viewDidLoad()

        //To show the side menu when swipe to left
        SideMenuManager.default.menuAddScreenEdgePanGesturesToPresent(toView: self.view, forMenu: UIRectEdge.left)
        
        tableView.delegate = self
        tableView.dataSource = self
        tableView.register(UINib(nibName: "WishListTableViewCell",bundle: nil), forCellReuseIdentifier: "wishListCells")
        self.tableView.rowHeight = UITableView.automaticDimension
        self.tableView.estimatedRowHeight = 100
        self.tableView.tableFooterView = UIView()
        self.tableView.separatorStyle = .none

        
        if userLoggedIn {
        let params : [String : String] = ["SystemPasscode" : systemPasscode , "Customer" : String(userId!)]
        getDataJson(params: params , i : 0)
        }
        
    }
    
    //MARK:- Actions
    @IBAction func cartTapped(_ sender: Any) {
        let cartStoryboard = UIStoryboard(name: "CartStoryboard", bundle: nil)
        let cartViewController = cartStoryboard.instantiateViewController(withIdentifier: "CartStoryboard") as! CartViewController
        //self.present(cartNavigationViewController, animated: false, completion: nil)
        
        self.navigationController?.pushViewController(cartViewController, animated: true)

    }
    @IBAction func searchTapped(_ sender: Any) {
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "SearchStoryboard") as! SearchViewController
        self.navigationController?.pushViewController(vc, animated: true)
    }
    @IBAction func showSideMenu(_ sender: Any) {
        present(SideMenuManager.default.menuLeftNavigationController!, animated: true, completion: nil)
    }
    
    //MARK:- Functions
    //get data from Web
    func getDataJson(params : [String : String] , i : Int){
        let url : String = BASEURL + subUrl
        showLoading()
        Alamofire.request(url, method: .post, parameters: params).responseJSON { response in
            if response.result.isSuccess {
                print("Success")
                let allWishListJson : JSON = JSON(response.result.value!)
                // print(allWishListJson)
                let errorMessage = allWishListJson["ErrorMessage"].stringValue
                if errorMessage == "" && i == 0
                {
                    self.wishListDataJSON = allWishListJson["Data"]["Data"].arrayValue
                    print("wishList : \(self.wishListDataJSON)")
                }else if errorMessage == "" && i == 1
                {
                   self.showErrorMessage(text: "Deleted Done")
                }else{
                     self.showErrorMessage(text: errorMessage)
                }
                self.isGetDataSuccess = true
                //print(self.dataArray[0].id)
                self.hideLoading()
                self.tableView.reloadData()
            }else {
                
                self.hideLoading()
                print("Failed requset api")
                 self.showErrorMessage(text: "Please Check Your Internet Connection")
            }
        }
    }
    
}
extension WishListViewController: UITableViewDelegate , UITableViewDataSource {
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if isGetDataSuccess {
            return wishListDataJSON.count
        }else
        {
            return 0
        }
        
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "wishListCells", for: indexPath) as! WishListTableViewCell
        if isGetDataSuccess {
            let imageName = wishListDataJSON[indexPath.row]["Images"]["NoColor"][0].stringValue
            let idProducts = wishListDataJSON[indexPath.row]["ID"].intValue
            let productName = wishListDataJSON[indexPath.row]["Name"].stringValue
            let descriptionName = wishListDataJSON[indexPath.row]["Content"].stringValue
            let productPrice = wishListDataJSON[indexPath.row]["Price"].stringValue + "$"
            cell.productImage.sd_setImage(with: URL(string: imageName), completed: nil)
            cell.productName.text = productName
            cell.productID = idProducts
            cell.descriptionProduct.text = descriptionName
            cell.productPrice.text = productPrice
        }
      //  cell.selectionStyle = .none
        return cell
    }
    
//    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
//        return self.view.frame.height / 6.8
//    }
    func tableView(_ tableView: UITableView, commit editingStyle: UITableViewCell.EditingStyle, forRowAt indexPath: IndexPath) {
        if editingStyle == .delete {
            self.subUrl = "\(deleteWishURL)"
            let isLoggedIn = UserDefaults.standard.bool(forKey: "isLoggedIn")
            if isLoggedIn {
                let params : [String : String] = ["SystemPasscode" : systemPasscode , "Product" : wishListDataJSON[indexPath.row]["ID"].stringValue , "Customer" : String(userId!)]
                getDataJson(params: params , i : 1)
                
            }else
            {
                self.showErrorMessage(text: "you must log in to add produts to your wish list")
            }
            print("Deleted")
            tableView.beginUpdates()
            wishListDataJSON.remove(at: indexPath.item)
            tableView.deleteRows(at: [indexPath],  with: UITableView.RowAnimation.automatic)
            tableView.endUpdates()
           // self.wishListDataJSON.remove(at: indexPath.row)
           // self.tableView.deleteRows(at: [indexPath], with: .automatic)
        }
    }
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        print(indexPath.row)
        
        // tableView.deselectRow(at: indexPath, animated: true)
    }
    
    
}
