//
//  signInViewController.swift
//  E-commerce
//
//  Created by juger on 8/2/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import Alamofire
import SwiftyJSON



class signInViewController: BaseVC {
    
    
    //MARK: -Outlets
    @IBOutlet weak var emailTextField: UITextField!
    @IBOutlet weak var passwordTextField: UITextField!
    @IBOutlet weak var forgetPasswordButton: UIButton!
    @IBOutlet weak var signInButton: UIButton!
    @IBOutlet weak var bGImageView: UIImageView!
    
    
    //MARK:- Variables
    let subUrlLogin: String = "\(BASEURL)\(loginURL)"
    let subUrlForgetPassword: String = "\(BASEURL)\(forgetURL)"
    let alertForgetPassword = UIAlertController(title: "Forget Password", message: "Please Enter Your Email", preferredStyle: UIAlertController.Style.alert)
    
    override func viewDidLoad() {
        super.viewDidLoad()
        //  AppUtility.lockOrientation(.portrait, andRotateTo: .portrait)
        AppUtility.lockOrientation(.portrait)
        //Call Change Color Placeholder Function
        changePlaceholderColor()
        
        //change design of sign in button
        setButtonsDesign()
        
        alertOptions()
        
        
    }
    
    //MARK: -Actions
    @IBAction func forgetPasswordTapped(_ sender: UIButton) {
        self.present(alertForgetPassword, animated: true, completion: nil)
    }
    @IBAction func signUpTapped(_ sender: UIButton) {
        AppUtility.lockOrientation(.all)
        performSegue(withIdentifier: "goToSignUpFromSignInSegue", sender: self)
    }
    
    @IBAction func signInTapped(_ sender: UIButton) {
        if isValidEmail(testStr: emailTextField.text!) {
            let params: [String : String] = ["SystemPasscode" : systemPasscode , "Email" : emailTextField.text! , "Password" : passwordTextField.text!]
            getDataJson(params: params)
        }else {
            showErrorMessage(text: "Your Email not Valid..Please check it")
        }
        
        AppUtility.lockOrientation(.all)
        
        
    }
    /**********************************Functions*******************************/
    //MARK: -Functions
    func alertOptions()
    {
        let okAction = UIAlertAction(title: "Ok", style: .default) { (alertAction) in
            let textField = self.alertForgetPassword.textFields![0] as UITextField
            print(textField.text!)
            let params : [String : String] = ["SystemPasscode" : systemPasscode , "Email" : textField.text!]
            self.getDataJsonForgetPassword(params: params)
            self.alertForgetPassword.textFields![0].text = ""
        }
        let cancelAction = UIAlertAction(title: "cancel", style: .default) { (alertAction) in
            print("cancel tapped")
        }
        alertForgetPassword.addTextField { (textField) in
            textField.placeholder = "Enter your Email"
            textField.borderStyle = .none
        }
        
        alertForgetPassword.addAction(okAction)
        alertForgetPassword.addAction(cancelAction)
    }

    func getDataJsonForgetPassword(params : [String : String]){
        showLoading()
        let url : String = subUrlForgetPassword
        Alamofire.request(url, method: .post, parameters: params).responseJSON { response in
            if response.result.isSuccess {
                print("Success")
                let forgetPasswordJson : JSON = JSON(response.result.value!)
                
                let message = forgetPasswordJson["ErrorMessage"].stringValue
                if message == ""
                {
                    print("Json file : \(forgetPasswordJson)")
                    
                }else
                {
                    self.showErrorMessage(text: message)
                }
                self.hideLoading()
                //print(self.dataArray[0].id)
                
            }else {
                self.hideLoading()
                self.showErrorMessage(text: "Failed to SignIn , Please check your internet connection")
            }
        }
    }
    //get data from Web
    func getDataJson(params : [String : String]){
        showLoading()
        let url : String = subUrlLogin
        Alamofire.request(url, method: .post, parameters: params).responseJSON { response in
            if response.result.isSuccess {
                print("Success")
                let loginJson : JSON = JSON(response.result.value!)
                print("Json file : \(loginJson)")
                //print(self.dataArray[0].id)
                let message = loginJson["ErrorMessage"].stringValue
                if message == "" {
                    let userID : Int = loginJson["Data"]["Data"]["ID"].intValue
                    userId = userID
                    let tempDic : [String : Any] = ["ID" : loginJson["Data"]["Data"]["ID"].stringValue , "fullName" : loginJson["Data"]["Data"]["Fullname"].stringValue,"email" : loginJson["Data"]["Data"]["Email"].stringValue , "zipCode" : loginJson["Data"]["Data"]["ZipCode"].stringValue , "phone" : loginJson["Data"]["Data"]["Phone"].stringValue,"mobile" : loginJson["Data"]["Data"]["Mobile"].stringValue,"insuranceName" : loginJson["Data"]["Data"]["InsuranceName"].stringValue , "insuranceNumber" : loginJson["Data"]["Data"]["InsuranceNumber"].stringValue,"isSubscribe" : loginJson["Data"]["Data"]["IsSubscribe"].stringValue , "isAndroid" : loginJson["Data"]["Data"]["IsAndroid"].stringValue,"imageURL" : loginJson["Data"]["Data"]["ImageURL"].stringValue]
                    userLoggedIn = true
                    UserDefaults.standard.set(userID, forKey: "userID")
                    UserDefaults.standard.set(userLoggedIn, forKey: "isLoggedIn")
//                    UserDefaults.standard.set(object: tempDic, forKey: "userInfo")
                    self.performSegue(withIdentifier: "signInToHomeSegue", sender: self)
                    
                    if let arr = loginJson["Data"]["Data"].dictionaryObject{
                        let me = User.getObject(arr)
                        me.statues_key = User.USER_STATUES.USER_REGISTERED.rawValue
                        User.saveMe(me: me)
                    }
                    
                }else
                {
                    self.showErrorMessage(text: message)
                }
                self.hideLoading()
                
               
            }else {
                self.hideLoading()
                self.showErrorMessage(text: "Failed to SignIn , Please check your internet connection")
            }
        }
    }
    
    
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        AppUtility.lockOrientation(.portrait)
        // Or to rotate and lock
        //AppUtility.lockOrientation(.portrait, andRotateTo: .portrait)
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        // Don't forget to reset when view is being removed
        AppUtility.lockOrientation(.all)
    }
    
    
    
    //make button with bordar
    func setButtonsDesign()
    {
        signInButton.backgroundColor = .clear
        signInButton.layer.cornerRadius = 25
        signInButton.layer.borderWidth = 2
        signInButton.layer.borderColor  = UIColor.white.cgColor
    }
    //Change Color Pf Placeholder
    func changePlaceholderColor()
    {
        emailTextField.attributedPlaceholder = NSAttributedString(string: "E-Mail",
                                                                  attributes: [NSAttributedString.Key.foregroundColor: UIColor.white])
        passwordTextField.attributedPlaceholder = NSAttributedString(string: "Password",
                                                                     attributes: [NSAttributedString.Key.foregroundColor: UIColor.white])
    }
    //To Make Status bar light Style
    override var preferredStatusBarStyle: UIStatusBarStyle {
        return .lightContent
    }
    override func viewDidLayoutSubviews() {
        
        //To Add under line to text Field
        let border = CALayer()
        let width = CGFloat(2.0)
        border.borderColor = UIColor.darkGray.cgColor
        border.frame = CGRect(x: 0, y: emailTextField.frame.size.height - width, width: emailTextField.frame.size.width, height: emailTextField.frame.size.height)
        border.borderWidth = width
        emailTextField.layer.addSublayer(border)
        emailTextField.layer.masksToBounds = true
        
        
        let border2 = CALayer()
        let width2 = CGFloat(2.0)
        border2.borderColor = UIColor.darkGray.cgColor
        border2.frame = CGRect(x: 0, y: passwordTextField.frame.size.height - width2, width: passwordTextField.frame.size.width, height: passwordTextField.frame.size.height)
        border2.borderWidth = width2
        passwordTextField.layer.addSublayer(border2)
        passwordTextField.layer.masksToBounds = true
        
    }
    
    
}
