//
//  signUpViewController.swift
//  E-commerce
//
//  Created by juger on 8/2/18.
//  Copyright © 2018 juger. All rights reserved.
//

import UIKit
import Alamofire
import SwiftyJSON


class signUpViewController: BaseVC , UIImagePickerControllerDelegate ,UINavigationControllerDelegate {
    
    
    //MARK: - Outlets
    @IBOutlet weak var fullNameTextField: UITextField!
    @IBOutlet weak var emailTextField: UITextField!
    @IBOutlet weak var passwordTextField: UITextField!
    @IBOutlet weak var confirmPasswordTextField: UITextField!
    @IBOutlet weak var zipCodeTextField: UITextField!
    @IBOutlet weak var phoneNumTextField: UITextField!
    @IBOutlet weak var mobileNumTextField: UITextField!
    @IBOutlet weak var insuranceNameTextField: UITextField!
    @IBOutlet weak var insuranceNumTextField: UITextField!
    @IBOutlet weak var signUpButton: UIButton!
    @IBOutlet weak var bGImageView: UIImageView!
    @IBOutlet weak var imagePickerTextField: UITextField!
    
    //MARK:- Variables
    let subUrl: String = "\(BASEURL)\(signupURL)"
    var imagePicker = UIImagePickerController()
    var url : URL!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        imagePicker.delegate = self
        
        AppUtility.lockOrientation(.portrait)
        
        //To make the textfield with uder line
        changePlaceHolderSettings()
        
        //To change design of sign up button
        setButtonsDesign()
    }
    
    
    //MARK:- Actions
    @IBAction func imagePickerTapped(_ sender: Any) {
        
        let alert = UIAlertController(title: "Choose Image", message: nil, preferredStyle: .actionSheet)
        alert.addAction(UIAlertAction(title: "Camera", style: .default, handler: { _ in
            self.openCamera()
        }))
        
        alert.addAction(UIAlertAction(title: "Gallery", style: .default, handler: { _ in
            self.openGallary()
        }))
        
        alert.addAction(UIAlertAction.init(title: "Cancel", style: .cancel, handler: nil))
        
        /*If you want work actionsheet on ipad
         then you have to use popoverPresentationController to present the actionsheet,
         otherwise app will crash on iPad */
        switch UIDevice.current.userInterfaceIdiom {
        case .pad:
            alert.popoverPresentationController?.sourceView = sender as? UIView
            alert.popoverPresentationController?.sourceRect = (sender as AnyObject).bounds
            alert.popoverPresentationController?.permittedArrowDirections = .up
        default:
            break
        }
        
        self.present(alert, animated: true, completion: nil)
    }
    @IBAction func signInTapped(_ sender: UIButton) {
        AppUtility.lockOrientation(.all)
        performSegue(withIdentifier: "goToSignInFromSignUpSegue", sender: self)
        
    }
    //    @IBAction func signUpTapped(_ sender: UIButton) {
    //        AppUtility.lockOrientation(.all)
    //        if isValidEmail(testStr: emailTextField.text!)
    //        {
    //            let image = UIImage(named : "bag")
    //            let imagePNG = image!.pngData()
    //            let params : [String : Any] = ["SystemPasscode": systemPasscode , "Fullname" : fullNameTextField.text! , "Email" : emailTextField.text! , "Password" : passwordTextField.text! , "ZipCode" : zipCodeTextField.text! , "Phone" : phoneNumTextField.text! , "Mobile" : mobileNumTextField.text! , "InsuranceName" : insuranceNameTextField.text! , "InsuranceNumber" : insuranceNumTextField.text! , "IsAndroid" : "0" , "Token" : "0","Image" : imagePNG!]
    //            getDataJson(params: params)
    //        }else
    //        {
    //            let message = "Please Enter a Valid Email"
    //            showErrorMessage(text: message)
    //        }
    //
    //    }
    
    
    @IBAction func signUpTapped(_ sender: UIButton) {
        AppUtility.lockOrientation(.all)
        if isValidEmail(testStr: emailTextField.text!)
        {
            
            self.showLoading()
            Alamofire.upload(
                multipartFormData: { multipartFormData in
                    
                    if let myURL = self.url{
                        multipartFormData.append(myURL, withName: "Image")
                    }
                    multipartFormData.append(systemPasscode.getData, withName: "SystemPasscode")
                    
                    
                    multipartFormData.append(self.fullNameTextField.text!.getData, withName: "Fullname")
                    multipartFormData.append(self.emailTextField.text!.getData, withName: "Email")
                    multipartFormData.append(self.passwordTextField.text!.getData, withName: "Password")
                    multipartFormData.append(self.zipCodeTextField.text!.getData, withName: "ZipCode")
                    multipartFormData.append(self.phoneNumTextField.text!.getData, withName: "Phone")
                    multipartFormData.append(self.mobileNumTextField.text!.getData, withName: "Mobile")
                    multipartFormData.append(self.insuranceNameTextField.text!.getData, withName: "InsuranceName")
                    multipartFormData.append(self.insuranceNumTextField.text!.getData, withName: "InsuranceNumber")
                    multipartFormData.append("0".getData, withName: "IsAndroid")
                    multipartFormData.append("0".getData, withName: "Token")
                    
            },
                to: BASEURL + signupURL ,headers : nil,
                encodingCompletion: { encodingResult in
                    
                    switch encodingResult {
                    case .success(let upload, _, _):
                        
                        upload.uploadProgress(closure: { (Progress) in
                            print("Upload Progress: \(Progress.fractionCompleted)")
                            if Progress.fractionCompleted == 1{
                            }
                        })
                        
                        upload.responseJSON { response in
                            if response.result.isSuccess {
                                print("Success")
                                let signUpJson : JSON = JSON(response.result.value!)
                                let message = signUpJson["ErrorMessage"].stringValue
                                if message == "" {
                                    self.hideLoading()
                                    let userID : Int = signUpJson["Data"]["Data"]["ID"].intValue
                                    userId = userID
                                    let tempDic : [String : String?] = ["fullname" : self.fullNameTextField.text!
                                        , "email" : self.emailTextField.text! ,
                                          "zipCode" : self.zipCodeTextField.text! ,
                                          "phone" : self.phoneNumTextField.text! ,
                                          "mobile" : self.mobileNumTextField.text! ,
                                          "insuranceName" : self.insuranceNameTextField.text! ,
                                          "insuranceNumber" : self.insuranceNumTextField.text! ,
                                          "isAndroid" : "0" ,
                                          "imageURL" : "0"]
                                    userLoggedIn = true
                                    UserDefaults.standard.set(userID, forKey: "userID")
                                    UserDefaults.standard.set(userLoggedIn, forKey: "isLoggedIn")
                                    UserDefaults.standard.set(object: tempDic, forKey: "userInfo")
                                    self.performSegue(withIdentifier: "signUpToHomeSegue", sender: self)
                                }else
                                {
                                    self.hideLoading()
                                    self.showErrorMessage(text: message)
                                }
                                
                                
                            }else {
                                self.hideLoading()
                                self.showErrorMessage(text: "Failed to SignUp , Please check your internet connection")
                            }
                        }
                        
                    case .failure(let encodingError):
                        //                    self.hideLoading()
                        print(encodingError)
                    }
            })
        }else{
            let message = "Please Enter a Valid Email"
            showErrorMessage(text: message)
        }
        
    }
    
    //MARK:- Functions
    func openCamera()
    {
        if(UIImagePickerController .isSourceTypeAvailable(UIImagePickerController.SourceType.camera))
        {
            imagePicker.sourceType = UIImagePickerController.SourceType.camera
            imagePicker.allowsEditing = true
            imagePicker.delegate = self
            self.present(imagePicker, animated: true, completion: nil)
        }
        else
        {
            let alert  = UIAlertController(title: "Warning", message: "You don't have camera", preferredStyle: .alert)
            alert.addAction(UIAlertAction(title: "OK", style: .default, handler: nil))
            self.present(alert, animated: true, completion: nil)
        }
    }
    
    func openGallary()
    {
        imagePicker.sourceType = UIImagePickerController.SourceType.photoLibrary
        imagePicker.allowsEditing = true
        imagePicker.delegate = self
        self.present(imagePicker, animated: true, completion: nil)
    }
    
    func imagePickerControllerDidCancel(_ picker: UIImagePickerController) {
        // Dismiss the picker if the user canceled.
        
        picker.dismiss(animated: true, completion: nil)
    }
    
    
    func imagePickerController(_ picker: UIImagePickerController, didFinishPickingMediaWithInfo info: [UIImagePickerController.InfoKey : Any]) {
        
        let selectedImage = info[UIImagePickerController.InfoKey.originalImage] as! UIImage
        
        self.url = savePhotoLocal(selectedImage)
        
        // Dismiss the picker.
        picker.dismiss(animated: true, completion: nil)
    }
    
    
    
    func savePhotoLocal(_ img : UIImage) -> URL?{
        let tt = img//.resized(toWidth: 512)
        
        print("WIDTH \(img.size.width) -- HIGHT \(img.size.height)")
        
        var imageData = tt.pngData()
        
        let imageSize: Int = imageData!.count
        print("size of image in KB: %f ", imageSize / 1024)
        
        //        if (imageSize / 1024) > 2000 {
        //            return nil
        //        }
        
        let random = CGFloat.random()
        
        if let dir = FileManager.default.urls(for: .documentDirectory, in: .userDomainMask).first {
            
            let path = dir.appendingPathComponent("imgProfile\(random).png")
            
            //writing
            do {
                try imageData!.write(to: path, options: Data.WritingOptions.atomic)
            }
            catch {}
        }
        
        let rrr = FileManager.default.urls(for: .documentDirectory, in: .userDomainMask).first!
        
        return  rrr.appendingPathComponent("imgProfile\(random).png")
    }
    
    
    func changePlaceHolderSettings()
    {
        changePlaceholderColor(fullNameTextField, "Full Name")
        changePlaceholderColor(emailTextField, "E-Mail")
        changePlaceholderColor(passwordTextField, "Password")
        changePlaceholderColor(confirmPasswordTextField, "Confirm Password")
        changePlaceholderColor(zipCodeTextField, "Zip Code")
        changePlaceholderColor(phoneNumTextField, "Phone Number")
        changePlaceholderColor(mobileNumTextField, "Mobile Number")
        changePlaceholderColor(insuranceNameTextField, "Insurance Name")
        changePlaceholderColor(insuranceNumTextField, "Insurance Number")
        changePlaceholderColor(imagePickerTextField, "Tap To Take An Image")
    }
    //get data from Web
    func getDataJson(params : [String : Any]){
        showLoading()
        let url : String = subUrl
        Alamofire.request(url, method: .post, parameters: params).responseJSON { response in
            if response.result.isSuccess {
                print("Success")
                let signUpJson : JSON = JSON(response.result.value!)
                let message = signUpJson["ErrorMessage"].stringValue
                if message == "" {
                    self.hideLoading()
                    let userID : Int = signUpJson["Data"]["Data"]["ID"].intValue
                    userId = userID
                    let tempDic : [String : String?] = ["fullname" : self.fullNameTextField.text!
                        , "email" : self.emailTextField.text! ,
                          "zipCode" : self.zipCodeTextField.text! ,
                          "phone" : self.phoneNumTextField.text! ,
                          "mobile" : self.mobileNumTextField.text! ,
                          "insuranceName" : self.insuranceNameTextField.text! ,
                          "insuranceNumber" : self.insuranceNumTextField.text! ,
                          "isAndroid" : "0" ,
                          "imageURL" : "0"]
                    userLoggedIn = true
                    UserDefaults.standard.set(userID, forKey: "userID")
                    UserDefaults.standard.set(userLoggedIn, forKey: "isLoggedIn")
                    UserDefaults.standard.set(object: tempDic, forKey: "userInfo")
                    self.performSegue(withIdentifier: "signUpToHomeSegue", sender: self)
                }else
                {
                    self.hideLoading()
                    self.showErrorMessage(text: message)
                }
                
                
            }else {
                self.hideLoading()
                self.showErrorMessage(text: "Failed to SignUp , Please check your internet connection")
            }
        }
    }
    
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        AppUtility.lockOrientation(.portrait)
        // Or to rotate and lock
        // AppUtility.lockOrientation(.portrait, andRotateTo: .portrait)
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        // Don't forget to reset when view is being removed
        AppUtility.lockOrientation(.all)
    }
    
    func changePlaceholderColor(_ textField: UITextField ,_ placeHolder : String)
    {
        textField.attributedPlaceholder = NSAttributedString(string: placeHolder,
                                                             attributes: [NSAttributedString.Key.foregroundColor: UIColor.white])
        
    }
    override var preferredStatusBarStyle: UIStatusBarStyle
    {
        return .lightContent
    }
    func setButtonsDesign()
    {
        signUpButton.backgroundColor = .clear
        signUpButton.layer.cornerRadius = 25
        signUpButton.layer.borderWidth = 2
        signUpButton.layer.borderColor  = UIColor.white.cgColor
    }
    
    func putLineUderTextField(_ textField: UITextField)
    {
        let border = CALayer()
        let width = CGFloat(2.0)
        border.borderColor = UIColor.darkGray.cgColor
        border.frame = CGRect(x: 0, y: textField.frame.size.height - width, width: textField.frame.size.width, height: textField.frame.size.height)
        border.borderWidth = width
        textField.layer.addSublayer(border)
        textField.layer.masksToBounds = true
    }
    
    override func viewDidLayoutSubviews() {
        
        //To Add under line to text Field
        putLineUderTextField(fullNameTextField)
        putLineUderTextField(emailTextField)
        putLineUderTextField(passwordTextField)
        putLineUderTextField(confirmPasswordTextField)
        putLineUderTextField(zipCodeTextField)
        putLineUderTextField(phoneNumTextField)
        putLineUderTextField(mobileNumTextField)
        putLineUderTextField(insuranceNameTextField)
        putLineUderTextField(insuranceNumTextField)
        putLineUderTextField(imagePickerTextField)
        
    }
    
    
    
}
