//
//  AppDelegate.swift
//  We1l
//
//  Created by Yahya Tabba on 2/8/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit
import IQKeyboardManagerSwift
import SwiftyJSON

@UIApplicationMain
class AppDelegate: UIResponder, UIApplicationDelegate {

    var window: UIWindow?
    var storyboard : UIStoryboard = UIStoryboard.init(name: "Main", bundle: nil)

    func application(_ application: UIApplication, didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?) -> Bool {
        // Override point for customization after application launch.
        
        IQKeyboardManager.shared.enable = true
        
        UINavigationBar.appearance().isTranslucent = true
        UINavigationBar.appearance().barTintColor = UIColor.white
        UINavigationBar.appearance().tintColor = Theme.Color.black2
        UINavigationBar.appearance().titleTextAttributes = [
            NSAttributedString.Key.foregroundColor : Theme.Color.black2,
            NSAttributedString.Key.font : Theme.Font.CairoRegular.withSize(20)
        ]

//        AppDelegate.setupViews()
        
        Communication.shared.locationInfo { (res) in
            Provider.currentLocation = res
        }
                
        return true
    }

    static func setupViews(){
        UIView.appearance().semanticContentAttribute = Local.isArabic() ? .forceRightToLeft : .forceLeftToRight
        
        let appDelegate = UIApplication.shared.delegate as! AppDelegate

        if User.isRegistered(){
            let vc = appDelegate.storyboard.instantiateViewController(withIdentifier: "TabBarVC") as! TabBarVC
//            let nv = UINavigationController.init(rootViewController: vc)
            appDelegate.window?.rootViewController = vc
        }else{
            let vc = appDelegate.storyboard.instantiateViewController(withIdentifier: "FirstVC") as! FirstVC
//            let nv = UINavigationController.init(rootViewController: vc)
            appDelegate.window?.rootViewController = vc
        }
    }
    
    func applicationWillResignActive(_ application: UIApplication) {
        // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
        // Use this method to pause ongoing tasks, disable timers, and invalidate graphics rendering callbacks. Games should use this method to pause the game.
    }

    func applicationDidEnterBackground(_ application: UIApplication) {
        // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
        // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
    }

    func applicationWillEnterForeground(_ application: UIApplication) {
        // Called as part of the transition from the background to the active state; here you can undo many of the changes made on entering the background.
    }

    func applicationDidBecomeActive(_ application: UIApplication) {
        // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
    }

    func applicationWillTerminate(_ application: UIApplication) {
        // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
    }

}

