//
//  EmptyView.swift
//  MyBox
//
//  Created by iOS Developer on 2/7/19.
//  Copyright © 2019 tradinos. All rights reserved.
//

import Foundation
import UIKit

extension UITableView {
    
    func setEmptyView(title: String, message: String, messageImage: UIImage, btn : UIButton! = nil,imageTint : UIColor! = nil) {
        
        let emptyView = empty(title: title, message: message, messageImage: messageImage, btn: btn)

        self.backgroundView = emptyView
        self.separatorStyle = .none
    }
    
    func restore() {
        self.backgroundView = nil
        self.separatorStyle = .singleLine
    }
    
}


extension UICollectionView{
    
    func setEmptyView(title: String, message: String, messageImage: UIImage, btn : UIButton! = nil) {
        
        let emptyView = empty(title: title, message: message, messageImage: messageImage, btn: btn)
        self.backgroundView = emptyView
    }
    
    func restore() {
        self.backgroundView = nil
    }

}


extension UIView{
    func empty(title: String, message: String, messageImage: UIImage, btn : UIButton! = nil,imageTint : UIColor! = nil) -> UIView {
        
        let emptyView = UIView(frame: CGRect(x: self.center.x, y: self.center.y, width: self.bounds.size.width, height: self.bounds.size.height))
        
        let messageImageView = UIImageView()
        let titleLabel = UILabel()
        let messageLabel = UILabel()
        
        messageImageView.backgroundColor = .clear
        messageImageView.contentMode = .scaleAspectFit
        if imageTint != nil{
            messageImageView.image = messageImageView.image?.withRenderingMode(.alwaysTemplate)
            messageImageView.tintColor = imageTint
        }

        
        titleLabel.translatesAutoresizingMaskIntoConstraints = false
        messageImageView.translatesAutoresizingMaskIntoConstraints = false
        messageLabel.translatesAutoresizingMaskIntoConstraints = false
        
        titleLabel.textColor = UIColor.black
        titleLabel.font = Theme.Font.CairoRegular.withSize(18)
        
        messageLabel.textColor = UIColor.lightGray
        messageLabel.font = Theme.Font.CairoRegular
        
        emptyView.addSubview(titleLabel)
        emptyView.addSubview(messageImageView)
        emptyView.addSubview(messageLabel)
        
        messageImageView.centerXAnchor.constraint(equalTo: emptyView.centerXAnchor).isActive = true
        messageImageView.widthAnchor.constraint(equalToConstant: 150).isActive = true
        messageImageView.heightAnchor.constraint(equalToConstant: 150).isActive = true
        
        titleLabel.topAnchor.constraint(equalTo: messageImageView.bottomAnchor, constant: 8).isActive = true
        titleLabel.centerXAnchor.constraint(equalTo: emptyView.centerXAnchor).isActive = true
        
        messageLabel.topAnchor.constraint(equalTo: titleLabel.bottomAnchor, constant: 8).isActive = true
        messageLabel.centerXAnchor.constraint(equalTo: emptyView.centerXAnchor).isActive = true
        
        if btn != nil{
            btn.setTitleColor(UIColor.white, for: .normal)
            btn.backgroundColor = Theme.Color.orange
            btn.contentEdgeInsets = UIEdgeInsets.init(top: 4, left: 8, bottom: 4, right: 8)
            btn.titleLabel?.font = Theme.Font.CairoRegular
            btn.cornerRadius = 5
            btn.translatesAutoresizingMaskIntoConstraints = false
            emptyView.addSubview(btn)
            btn.topAnchor.constraint(equalTo: messageLabel.bottomAnchor, constant: 8).isActive = true
            btn.centerXAnchor.constraint(equalTo: emptyView.centerXAnchor).isActive = true
            messageImageView.bottomAnchor.constraint(equalTo: emptyView.centerYAnchor, constant: -20).isActive = true
        }else{
            messageImageView.centerYAnchor.constraint(equalTo: emptyView.centerYAnchor, constant: -20).isActive = true
        }
        
        messageImageView.image = messageImage
        titleLabel.text = title
        messageLabel.text = message
        messageLabel.numberOfLines = 0
        messageLabel.textAlignment = .center
        
        
        /*
         UIView.animate(withDuration: 1, animations: {
         messageImageView.transform = CGAffineTransform(rotationAngle: .pi / 10)
         }, completion: { (finish) in
         UIView.animate(withDuration: 1, animations: {
         messageImageView.transform = CGAffineTransform(rotationAngle: -1 * (.pi / 10))
         }, completion: { (finishh) in
         UIView.animate(withDuration: 1, animations: {
         messageImageView.transform = CGAffineTransform.identity
         })
         })
         })*/
        
        return emptyView
    }

}
