//
//  Address.swift
//  We1l
//
//  Created by Yahya Tabba on 2/17/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import Foundation
import ObjectMapper
import SwiftyJSON

class Address : BaseEntity{
    
    var RegionID : JSON!
    var CityID : JSON!
    var CountryID : JSON!
    var Region : String!
    var City : String!
    var Country : String!
    var Content : String!
    var Lat : JSON!
    var Lon : JSON!
    var Name : String!
    
    required convenience public init?(map: Map) {
        self.init()
    }
    
    override func mapping(map: Map) {
        super.mapping(map: map)
        
        RegionID <- map["RegionID"]
        CityID <- map["CityID"]
        CountryID <- map["CountryID"]
        Region <- map["Region"]
        City <- map["City"]
        Country <- map["Country"]
        Content <- map["Content"]
        Lat <- map["Lat"]
        Lon <- map["Lon"]
        Name <- map["Name"]
    }
}
