//
//  Elanat.swift
//  We1l
//
//  Created by Yahya Tabba on 2/13/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import Foundation
import ObjectMapper
import SwiftyJSON

class Elanat : BaseEntity{
    
    var Gold : ElanType!
    var Silver : ElanType!
    var Bronze : ElanType!
    
    
    required convenience public init?(map: Map) {
        self.init()
    }
    
    override func mapping(map: Map) {
        super.mapping(map: map)
        
        Gold <- map["Gold"]
        Silver <- map["Silver"]
        Bronze <- map["Bronze"]
    }
}

class ElanType : BaseEntity{
    
    var Full = [Elan]()
    var Mid = [Elan]()
    var Small = [Elan]()
    
    
    required convenience public init?(map: Map) {
        self.init()
    }
    
    override func mapping(map: Map) {
        super.mapping(map: map)
        
        Full <- map["Full"]
        Mid <- map["Mid"]
        Small <- map["Small"]
    }
}

class Elan : BaseEntity{
    
    var ID : JSON!
    var Title : String!
    var Content : String!
    var ImageURL : String!
    var StartAt : JSON!
    var Name : String!
    var Mobile : String!
    var Email : String!
    var type : JSON!
    var PixelSize : JSON!
    
    
    required convenience public init?(map: Map) {
        self.init()
    }
    
    override func mapping(map: Map) {
        super.mapping(map: map)
        
        ID <- map["ID"]
        Title <- map["Title"]
        Content <- map["Content"]
        ImageURL <- map["ImageURL"]
        StartAt <- map["StartAt"]
        Name <- map["Name"]
        Mobile <- map["Mobile"]
        Email <- map["Email"]
        type <- map["Type"]
        PixelSize <- map["PixelSize"]
    }
}





















