//
//  Language.swift
//  We1l
//
//  Created by Yahya Tabba on 6/9/20.
//  Copyright © 2020 Yahya Tabba. All rights reserved.
//

import Foundation
import SwiftyJSON

struct Localizations: Codable {
    var strings: JSON
}

class Local{
    static func setCurrent(_ data : Any, lang : Lang){
        let defaults = UserDefaults.standard
        
        let obj = Localizations.init(strings: JSON.init(data))
        let encoder = JSONEncoder()
        if let encoded = try? encoder.encode(obj) {
            defaults.set(encoded, forKey: "currentLanguage")
        }
        
        defaults.set(lang.Name, forKey: "languageName")
        defaults.set(lang.Symbol, forKey: "languageSymbol")
        defaults.set(lang.ID?.stringValue ?? "", forKey: "langID")
        
        if let symbol = lang.Symbol{
            if symbol.lowercased().contains("ar"){
                defaults.setValue(["ar","en"], forKey: "AppleLanguages")
            }else{
                defaults.setValue(["en","ar"], forKey: "AppleLanguages")
            }
        }
        
    }
    
    static func getString(_ s : String) -> String{
        var string : String = s
        
        if let obj = UserDefaults.standard.object(forKey: "currentLanguage") as? Data {
            let decoder = JSONDecoder()
            if let loaded = try? decoder.decode(Localizations.self, from: obj) {
               string = (loaded.strings.dictionaryObject?[s] as? String) ?? s
            }
        }
        return string
    }
    
    static func getLanguageName() -> String?{
        return UserDefaults.standard.string(forKey: "languageName")
    }
    static func getLanguageSymbol() -> String?{
        return UserDefaults.standard.string(forKey: "languageSymbol")
    }
    static func getLanguageID() -> String?{
        return UserDefaults.standard.string(forKey: "langID")
    }
    
    static func isArabic() -> Bool{
        if let arr = UserDefaults.standard.value(forKey: "AppleLanguages") as? [String]{
            if let first = arr.first{
                return first.lowercased().contains("ar")
            }
        }
        
        return false
    }
    
}
