//
//  User.swift
//  We1l
//
//  Created by Yahya Tabba on 2/10/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//


import Foundation
import SwiftyJSON

class User : NSObject, NSCoding{
    
    static let KEY_USER_ME : String = "me"
    
    var ID : String!
    var Fullname : String!
    var Email : String!
    var ZipCode : String!
    var Phone : String!
    var Mobile : String!
    var InsuranceName : String!
    var InsuranceNumber : String!
    var IsSubscribe : String!
    var IsAndroid : String!
    var Token : String!
    var ImageURL : String!
    
    var Currency : String!
    var StoreCredit : String!
    
    //MARK: Local data
    var statues_key: String? = USER_STATUES.NEW_USER.rawValue
    
    enum USER_STATUES : String {
        case NEW_USER = "new"
        case PENDING_CODE = "pending_code"
        case PENDING_PROFILE = "pending_profile"
        case USER_REGISTERED = "registered"
    }
    
    //MARK: chache current user
    static func getCurrentUser() -> User
    {
        if let archivedData = UserDefaults.standard.object(forKey: KEY_USER_ME) as? Data
        {
            do{
                if let me = try NSKeyedUnarchiver.unarchiveTopLevelObjectWithData(archivedData) as? User{
                    return me
                }
            }catch let err{
                print("ERR1 : \(err.localizedDescription)")
            }
        }
        return User()
    }
    
    static func saveMe(me : User)
    {
        let archivedObject = try NSKeyedArchiver.archivedData(withRootObject: me)
        UserDefaults.standard.set(archivedObject, forKey: KEY_USER_ME)
        UserDefaults.standard.synchronize()
    }
    
    static func clearMe()
    {
        UserDefaults.standard.removeObject(forKey: KEY_USER_ME)
    }
    
    
    override init(){
        
    }
    
    required init(coder decoder: NSCoder) {
        self.statues_key = decoder.decodeObject(forKey: "statues_key") as? String
        
        
        self.ID = decoder.decodeObject(forKey: "ID") as? String
        self.Fullname = decoder.decodeObject(forKey: "Fullname") as? String
        self.Email = decoder.decodeObject(forKey: "Email") as? String
        self.ZipCode = decoder.decodeObject(forKey: "ZipCode") as? String
        self.Phone = decoder.decodeObject(forKey: "Phone") as? String
        self.Mobile = decoder.decodeObject(forKey: "Mobile") as? String
        self.InsuranceName = decoder.decodeObject(forKey: "InsuranceName") as? String
        self.InsuranceNumber = decoder.decodeObject(forKey: "InsuranceNumber") as? String
        self.IsSubscribe = decoder.decodeObject(forKey: "IsSubscribe") as? String
        self.IsAndroid = decoder.decodeObject(forKey: "IsAndroid") as? String
        self.Token = decoder.decodeObject(forKey: "Token") as? String
        self.ImageURL = decoder.decodeObject(forKey: "ImageURL") as? String
        self.Currency = decoder.decodeObject(forKey: "Currency") as? String
        self.StoreCredit = decoder.decodeObject(forKey: "StoreCredit") as? String
    }
    
    
    func encode(with coder: NSCoder) {
        coder.encode(statues_key, forKey: "statues_key")
        
        coder.encode(ID, forKey: "ID")
        coder.encode(Fullname, forKey: "Fullname")
        coder.encode(Email, forKey: "Email")
        coder.encode(ZipCode, forKey: "ZipCode")
        coder.encode(Phone, forKey: "Phone")
        coder.encode(Mobile, forKey: "Mobile")
        coder.encode(InsuranceName, forKey: "InsuranceName")
        coder.encode(InsuranceNumber, forKey: "InsuranceNumber")
        coder.encode(IsSubscribe, forKey: "IsSubscribe")
        coder.encode(IsAndroid, forKey: "IsAndroid")
        coder.encode(Token, forKey: "Token")
        coder.encode(ImageURL, forKey: "ImageURL")
        coder.encode(Currency, forKey: "Currency")
        coder.encode(StoreCredit, forKey: "StoreCredit")
    }
    
    
    static func isRegistered() -> Bool{
        return (User.getCurrentUser().statues_key == User.USER_STATUES.USER_REGISTERED.rawValue)
    }
    
    
    static func getObject(_ dic : [String : Any]) -> User{
        let me = User.getCurrentUser()
        
        if let i = dic["ID"]{
            let x = JSON(i)
            me.ID = x.stringValue
        }
        
        me.Fullname = dic["Fullname"] as? String
        me.Email = dic["Email"] as? String
        me.ZipCode = dic["ZipCode"] as? String
        me.Phone = dic["Phone"] as? String
        me.Mobile = dic["Mobile"] as? String
        me.InsuranceName = dic["InsuranceName"] as? String
        me.InsuranceNumber = dic["InsuranceNumber"] as? String
        me.IsSubscribe = dic["IsSubscribe"] as? String
        me.IsAndroid = dic["IsAndroid"] as? String
        me.Token = dic["Token"] as? String
        me.ImageURL = dic["ImageURL"] as? String
        me.Currency = dic["Currency"] as? String
        me.StoreCredit = dic["StoreCredit"] as? String
        
        return me
    }
    
    static func getID() -> String!{
        return User.getCurrentUser().ID ?? nil
    }
    
    static func getImg() -> String!{
        return User.getCurrentUser().ImageURL
    }
    
    static func getCurrency() -> String{
        return User.getCurrentUser().Currency ?? "1"
    }
    
    static func getStoreCredit() -> String{
        return User.getCurrentUser().StoreCredit ?? "0"
    }

    
}

