//
//  extensions.swift
//  Prodygie
//
//  Created by Yahya Tabba on 4/21/18.
//  Copyright © 2018 Autotech co. All rights reserved.
//
import Foundation
import SwiftyJSON
import UIKit
import AFDateHelper

extension String{
    
    // to get notification center Name
    var not : NSNotification.Name {
        return NSNotification.Name.init(rawValue: self)
    }
    
    var getData : Data {
        if self != ""{
            return self.data(using: String.Encoding.utf8)!
        }else{
            return Data()
        }
    }
    
    func isValidEmail() -> Bool {
        // here, `try!` will always succeed because the pattern is valid
        let regex = try! NSRegularExpression(pattern: "[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,64}", options: .caseInsensitive)
        return regex.firstMatch(in: self, options: [], range: NSRange(location: 0, length: count)) != nil
    }

    
    var localized : String{
        
        return Local.getString(self)
        /*if let arr =  UserDefaults.standard.value(forKey: "AppleLanguages") as? [String]{
            if let lang = arr.first{
                var lang2 = lang
                if !lang2.contains("pt"){
                    lang2 = "Base"
                }
                let path  = Bundle.main.path(forResource: lang2, ofType: "lproj")
                let bundle = Bundle.init(path: path!)
                let s = bundle!.localizedString(forKey: self, value: nil, table: nil)
                return s
            }
        }
        
        return "TEST";
        //        return NSLocalizedString(self, comment: "")*/
    }
    
    
    
    
    var localized_currancy : String{
        return String(format: NSLocalizedString("%@ Price", comment: ""), "\(self)")
    }
    
    
    // to get string after convert from html
    //    var html2String: String {
    //        return html2AttributedString?.string ?? ""
    //    }
    //    var html2AttributedString: NSAttributedString? {
    //        guard let data = data(using: .utf8) else { return nil }
    //        do {
    //            return try NSAttributedString(data: data, options: [NSDocumentTypeDocumentAttribute: NSHTMLTextDocumentType, NSCharacterEncodingDocumentAttribute: String.Encoding.utf8.rawValue], documentAttributes: nil)
    //        } catch let error as NSError {
    //            print(error.localizedDescription)
    //            return  nil
    //        }
    //    }
    
    func convertToDictionary() -> [String: Any]? {
        if let data = self.data(using: .utf8) {
            do {
                return try JSONSerialization.jsonObject(with: data, options: []) as? [String: Any]
            } catch {
                print(error.localizedDescription)
            }
        }
        return nil
    }
    
}

extension UIImage {
    func resized(withPercentage percentage: CGFloat) -> UIImage? {
        let canvasSize = CGSize(width: size.width * percentage, height: size.height * percentage)
        UIGraphicsBeginImageContextWithOptions(canvasSize, false, scale)
        defer { UIGraphicsEndImageContext() }
        draw(in: CGRect(origin: .zero, size: canvasSize))
        return UIGraphicsGetImageFromCurrentImageContext()
    }
    func resized(toWidth width: CGFloat) -> UIImage? {
        let canvasSize = CGSize(width: width, height: CGFloat(ceil(width/size.width * size.height)))
        UIGraphicsBeginImageContextWithOptions(canvasSize, false, scale)
        defer { UIGraphicsEndImageContext() }
        draw(in: CGRect(origin: .zero, size: canvasSize))
        return UIGraphicsGetImageFromCurrentImageContext()
    }
    
    func resized(toHeight height: CGFloat) -> UIImage? {
        let canvasSize = CGSize(width: CGFloat(ceil(height/size.height * size.width)), height: height)
        UIGraphicsBeginImageContextWithOptions(canvasSize, false, scale)
        defer { UIGraphicsEndImageContext() }
        draw(in: CGRect(origin: .zero, size: canvasSize))
        return UIGraphicsGetImageFromCurrentImageContext()
    }

    
    convenience init(view: UIView) {
        
        UIGraphicsBeginImageContextWithOptions(view.bounds.size, false, 0.0)
        //        UIColor.white.setFill()
        view.drawHierarchy(in: view.bounds, afterScreenUpdates: false)
        let image = UIGraphicsGetImageFromCurrentImageContext()
        UIGraphicsEndImageContext()
        self.init(cgImage: (image?.cgImage)!)
        
        
    }
    
    
    
}



extension UIColor{
    
    public convenience init(_ hex : String) {
        var cString:String = hex.trimmingCharacters(in: .whitespacesAndNewlines).uppercased()
        
        if (cString.hasPrefix("#")) {
            cString.remove(at: cString.startIndex)
        }
        
        if ((cString.count) != 6) {
            self.init(red: 255/255, green: 0, blue: 0, alpha: 1)// UIColor.gray
            return
        }
        
        var rgbValue:UInt32 = 0
        Scanner(string: cString).scanHexInt32(&rgbValue)
        
        self.init(
            red: CGFloat((rgbValue & 0xFF0000) >> 16) / 255.0,
            green: CGFloat((rgbValue & 0x00FF00) >> 8) / 255.0,
            blue: CGFloat(rgbValue & 0x0000FF) / 255.0,
            alpha: CGFloat(1.0)
        )
    }
    
    static func random() -> UIColor {
        return UIColor(red:   .random(),
                       green: .random(),
                       blue:  .random(),
                       alpha: 1.0)
    }
    
}

extension CGFloat {
    static func random() -> CGFloat {
        return CGFloat(arc4random()) / CGFloat(UInt32.max)
    }
}




extension UIView {
    
    @IBInspectable var cornerRadius: CGFloat {
        get {
            return layer.cornerRadius
        }
        set {
            layer.cornerRadius = newValue
            layer.masksToBounds = newValue > 0
        }
    }
    
    @IBInspectable var borderWidth: CGFloat {
        get {
            return layer.borderWidth
        }
        set {
            layer.borderWidth = newValue
        }
    }
    
    @IBInspectable var borderColor: UIColor? {
        get {
            return UIColor.init(cgColor: layer.borderColor!)
        }
        set {
            layer.borderColor = newValue?.cgColor
        }
    }
    
    
    func roundCorners(_ corners: UIRectCorner, radius: CGFloat) {
        let path = UIBezierPath(roundedRect: self.bounds, byRoundingCorners: corners, cornerRadii: CGSize(width: radius, height: radius))
            let mask = CAShapeLayer()
            mask.path = path.cgPath
            self.layer.mask = mask
    }

}

extension UITextField{
    
    @IBInspectable var placeHolderColor: UIColor? {
        get {
            return self.placeHolderColor
        }
        set {
            if let ph = newValue{
                let p = self.placeholder != nil ? self.placeholder! : ""
                self.attributedPlaceholder = NSAttributedString(string:p, attributes:[NSAttributedString.Key.foregroundColor: ph])
            }
        }
    }
}

extension UISearchBar {
    
    func change(_ textFont : UIFont?) {
        
        for view : UIView in (self.subviews[0]).subviews {
            
            if let textField = view as? UITextField {
                textField.font = textFont
            }
        }
    }
}


extension Double{
    
    func formatDigital() -> String {
        let formatter = NumberFormatter()
        formatter.numberStyle = .decimal
        formatter.maximumFractionDigits = 0;
        formatter.locale = Locale(identifier: Locale.current.identifier)
        let result = formatter.string(from: self as NSNumber);
        return result!;
    }
    
}

extension JSON{
    
    var Boolean : Bool{
        if self.boolValue || self.intValue == 1{
            return true
        }else{
            return false
        }
    }
}

extension UIImageView{
    
    @IBInspectable var renderTemplete: Bool {
        get {
            return false
        }
        set {
            if newValue{
                if self.image != nil{
                    self.image = self.image!.withRenderingMode(.alwaysTemplate)
                }
            }
        }
    }
}

extension UIButton{
    
    @IBInspectable var templeteRendar: Bool {
        get {
            return false
        }
        set {
            if newValue{
                if self.imageView != nil, self.imageView?.image != nil{
                    self.setImage(self.imageView!.image!.withRenderingMode(.alwaysTemplate), for: .normal)
                }
            }
        }
    }
}

// Date
extension String{
    
    /// yyyy-MM-dd
    var dateOnly : String{
        if let date = Date.init(fromString: self, format: DateFormatType.custom("yyyy-MM-dd hh:mm:ss")){
            return date.toString(format: DateFormatType.isoDate)
        }
        return self
    }
    
    /// HH:mm a
    var timeOnly : String{
        if let date = Date.init(fromString: self, format: DateFormatType.custom("yyyy-MM-dd hh:mm:ss")){
            return date.toString(format: DateFormatType.custom("HH:mm a"))
        }
        return self
    }
    
    /// yyyy-MM-dd hh:mm a
    var dateTime : String{
        if let date = Date.init(fromString: self, format: DateFormatType.custom("yyyy-MM-dd hh:mm:ss")){
            return date.toString(format: DateFormatType.custom("yyyy-MM-dd hh:mm a"))
        }
        return self
    }
    
    /// custom format
    func dateCustom(_ format : String) -> String{
        if let date = Date.init(fromString: self, format: DateFormatType.custom("yyyy-MM-dd hh:mm:ss")){
            return date.toString(format: DateFormatType.custom(format))
        }
        return self
    }


    
}


extension Date{
    
    
    var dayName : String{
        let formatter = DateFormatter()
        formatter.dateFormat = "EEEE"
        let dayInWeek = formatter.string(from: self).prefix(3)
        return String(dayInWeek)
    }

    var dayNameFull : String{
        let formatter = DateFormatter()
        formatter.dateFormat = "EEEE"
        let dayInWeek = formatter.string(from: self)
        return dayInWeek
    }
    
}

class myTapGuester : UITapGestureRecognizer{
    
    var tag = Int()
    
}


extension UIView {
    class func fromNib<T: UIView>() -> T {
        return Bundle.main.loadNibNamed(String(describing: T.self), owner: nil, options: nil)![0] as! T
    }
}

extension UIImageView{
    
    @IBInspectable var tintColor2 : UIColor!{
        get { return nil}
        set{
            if let img = self.image{
                self.image = img.withRenderingMode(.alwaysTemplate)
                self.tintColor = newValue
            }
        }
    }
    
}

extension UITextField {
    
    func setLeftPaddingPoints(_ amount:CGFloat){
        let paddingView = UIView(frame: CGRect(x: 0, y: 0, width: amount, height: self.frame.size.height))
        self.leftView = paddingView
        self.leftViewMode = .always
    }
    
    func setRightPaddingPoints(_ amount:CGFloat) {
        let paddingView = UIView(frame: CGRect(x: 0, y: 0, width: amount, height: self.frame.size.height))
        self.rightView = paddingView
        self.rightViewMode = .always
    }
    
    
    @IBInspectable var rightImage : UIImage!{
        get { return nil}
        set{
            self.rightView = UIImageView(image: newValue)
            self.rightViewMode = UITextField.ViewMode.always
        }
    }
    
    @IBInspectable var leftImage : UIImage!{
        get { return nil}
        set{
            let v = UIImageView(image: newValue)
            v.frame = CGRect.init(x: 8, y: v.frame.origin.y, width: v.frame.size.width, height: v.frame.size.height)
            let t = UIView.init(frame: CGRect.init(x: v.frame.origin.x, y: v.frame.origin.y, width: v.frame.size.width + 16, height: v.frame.size.height))
            t.addSubview(v)
            t.backgroundColor = .clear
            self.leftView = t//UIImageView(image: newValue)
            self.leftViewMode = UITextField.ViewMode.always
        }
    }
    
}



extension JSON{
    
    var fromPrice : String{
        if let d = Double.init(self.stringValue){
            let numberOfPlaces = 2.0
            let multiplier = pow(10.0, numberOfPlaces)
            let rounded = round(d * multiplier) / multiplier
            return rounded == Double(Int(rounded)) ? "\(Int(rounded))" : "\(rounded)"
        }
        return self.stringValue
    }
    
    
}



class customLongPressGesture : UILongPressGestureRecognizer{
    var tag : Int = 0
    var tagString : String = "0"
}




