//
//  Communication.swift
//  We1l
//
//  Created by Yahya Tabba on 2/9/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import Foundation
import Alamofire
import AlamofireObjectMapper
import SwiftyJSON
import ObjectMapper

let SystemPasscode = "PYxqb@vb"
typealias ServiceResponse = (JSON?, NSError?) -> Void

class Communication: BaseManager {
    
    static var shared = Communication()
    
    private let encodingQuery = URLEncoding(destination: .queryString)
    private let encodingBody = URLEncoding(destination: .httpBody)
    
    var baseParams : [String : Any] {
        var params : [String : Any] = [:]
        params["SystemPasscode"] = SystemPasscode
        params["Currency"] = (Provider.currentLocation.CurrencyID == nil) ? "1" : Provider.currentLocation.CurrencyID.stringValue
        
        if let languageID = Local.getLanguageID(){
            params["Language"] = languageID
        }
        
        return params
    }
    
//    private let baseParams : [String : Any] = ["SystemPasscode" : "PYxqb@vb", "Language" : "1", "Currency" : "1"]
    
    func login(email : String, password : String, callback : @escaping (Bool) -> Void){
        let url = URL(string: baseURL + loginURL)!
        var params = self.baseParams
        params["Email"] = email
        params["Password"] = password
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: self.getHearders()).responseObject { (response : DataResponse<CustomResponse>) in
            self.output(response)
            switch response.result{
            case .success(let value):
                if value.status {

                    if let obj = value.Data["Data"].dictionaryObject{
                        let user = User.getObject(obj)
                        user.statues_key = User.USER_STATUES.USER_REGISTERED.rawValue
                        User.saveMe(me: user)
                    }
                    
                    callback(true)
                }else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }

    
    func getSlider(_ callback : @escaping ([SliderItem]) -> Void){
        let url = URL(string: baseURL + sliderURL)!
        let params = self.baseParams
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: self.getHearders()).responseObject { (response : DataResponse<CustomResponse>) in
            self.output(response)
            switch response.result{
            case .success(let value):
                if value.status {
                    var sliderItems = [SliderItem]()
                    for i in value.Data["Data"].arrayValue{
                        if let obj = i.dictionaryObject, let item = SliderItem(JSON: obj){
                            sliderItems.append(item)
                        }
                    }
                    callback(sliderItems)
                }else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }
    
    func getTodayTrending(_ callback : @escaping ([Product]) -> Void){
        let url = URL(string: baseURL + todayTrendingURL)!
        var params = self.baseParams
        
        if let id = User.getID(){
            params["Customer"] = id
        }
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: self.getHearders()).responseObject { (response : DataResponse<CustomResponse>) in
            self.output(response)
            switch response.result{
            case .success(let value):
                if value.status {
                    var items = [Product]()
                    for i in value.Data["Data"].arrayValue{
                        if let obj = i.dictionaryObject, let item = Product(JSON: obj){
                            items.append(item)
                        }
                    }
                    callback(items)
                }else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }
    
    func getBestSeller(_ callback : @escaping ([Seller]) -> Void){
        let url = URL(string: baseURL + bestSellerURL)!
        let params = self.baseParams
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: self.getHearders()).responseObject { (response : DataResponse<CustomResponse>) in
            self.output(response)
            switch response.result{
            case .success(let value):
                if value.status {
                    var items = [Seller]()
                    for i in value.Data["Data"].arrayValue{
                        if let obj = i.dictionaryObject, let item = Seller(JSON: obj){
                            items.append(item)
                        }
                    }
                    callback(items)
                }else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }
    
    func getTodayHotDeals(_ callback : @escaping ([Today]) -> Void){
        let url = URL(string: baseURL + todayHotDealsURL)!
        var params = self.baseParams
        
        if let id = User.getID(){
           params["Customer"] = id
        }
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: self.getHearders()).responseObject { (response : DataResponse<CustomResponse>) in
            self.output(response)
            switch response.result{
            case .success(let value):
                if value.status {
                    var items = [Today]()
                    for i in value.Data["Data"].arrayValue{
                        if let obj = i.dictionaryObject, let item = Today(JSON: obj){
                            items.append(item)
                        }
                    }
                    callback(items)
                }else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }
    
    func getNewArrivals(_ callback : @escaping ([Product]) -> Void){
        let url = URL(string: baseURL + newArrivalsURL)!
        let params = self.baseParams
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: self.getHearders()).responseObject { (response : DataResponse<CustomResponse>) in
            self.output(response)
            switch response.result{
            case .success(let value):
                if value.status {
                    var items = [Product]()
                    for i in value.Data["Data"].arrayValue{
                        if let obj = i.dictionaryObject, let item = Product(JSON: obj){
                            items.append(item)
                        }
                    }
                    callback(items)
                }else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }
    
    func search(Text : String, callback : @escaping ([Product]) -> Void){
        let url = URL(string: baseURL + searchURL)!
        var params = self.baseParams
        params["Text"] = Text

        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: self.getHearders()).responseObject { (response : DataResponse<CustomResponse>) in
            self.output(response)
            switch response.result{
            case .success(let value):
                if value.status {
                    var items = [Product]()
                    for i in value.Data["Data"].arrayValue{
                        if let obj = i.dictionaryObject, let item = Product(JSON: obj){
                            items.append(item)
                        }
                    }
                    callback(items)
                }else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }

    
    func deleteWish(ProductID : String, callback : @escaping (Bool) -> Void){
        let url = URL(string: baseURL + deleteWishURL)!

        var params = self.baseParams
        params["Product"] = ProductID
        params["Customer"] = User.getID()
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            self.output(response)
            switch response.result{
            case .success(let value):
                if value.status {
                    callback(value.Data["Status"].Boolean)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }
    
    func addWish(ProductID : String, callback : @escaping (Bool) -> Void){
        let url = URL(string: baseURL + addWishURL)!

        var params = self.baseParams
        params["Product"] = ProductID
        params["Customer"] = User.getID()
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            self.output(response)
            switch response.result{
            case .success(let value):
                if value.status {
                    callback(value.Data["Status"].Boolean)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }
    
    func product(ID : String,callback : @escaping (Product,JSON?) -> Void){
        let url = URL(string: baseURL + productURL)!
        
        var params = self.baseParams
        params["ID"] = ID
        
        if let id = User.getID(){
            params["Customer"] = id
        }

        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    if let i = value.Data["Data"].dictionaryObject{
                        if let a = Product(JSON: i){
                            callback(a,response.value?.Data)
                        }
                    }
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }
    
    
    func categories(callback : @escaping ([CategoryObj]) -> Void){
        let url = URL(string: baseURL + categoriesURL)!
        
        let params = self.baseParams
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [CategoryObj]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = CategoryObj(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }
    
    func category(ID : String, callback : @escaping (CategoryObj) -> Void){
        let url = URL(string: baseURL + categoryURL)!
        
        var params = self.baseParams
        params["ID"] = ID
        params["Customer"] = User.getID()
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    if let i = value.Data["Data"].dictionaryObject{
                        if let a = CategoryObj(JSON: i){
                            callback(a)
                        }
                    }
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }
    
    
    func getStoreCredit(Currency : String! = nil,callback : @escaping (Bool) -> Void){
        let url = URL(string: baseURL + getStoreCreditURL)!
        
        var params = self.baseParams
        params["Customer"] = User.getID()
        
        if Currency != nil{
            params["Currency"] = Currency
        }
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    let me = User.getCurrentUser()
                    me.StoreCredit = value.Data["Data"].stringValue
                    User.saveMe(me: me)
                    
                    callback(true)
                }
                else{
//                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure:
//                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func logout(callback : @escaping (Bool) -> Void){
        let url = URL(string: baseURL + logoutURL)!
        
        var params = self.baseParams
        params["ID"] = User.getID()
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    User.clearMe()
                    
                    callback(true)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }

    
    func myWish(callback : @escaping ([Product]) -> Void){
        let url = URL(string: baseURL + myWishURL)!
        var params = self.baseParams
        params["Customer"] = User.getID()
        

        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: self.getHearders()).responseObject { (response : DataResponse<CustomResponse>) in
            self.output(response)
            switch response.result{
            case .success(let value):
                if value.status {
                    
                    var items = [Product]()
                    for i in value.Data["Data"].arrayValue{
                        if let obj = i.dictionaryObject, let item = Product(JSON: obj){
                            items.append(item)
                        }
                    }
                    callback(items)
                }else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }
    
    
    func locationInfo(callback : @escaping (LocationInfo) -> Void){
        let url = URL(string: baseURL + locationInfoURL)!
        
        var params = self.baseParams
        params["Customer"] = User.getID()
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    if let i = value.Data.dictionaryObject{
                        if let a = LocationInfo(JSON: i){
                            callback(a)
                        }
                    }
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }


    func elanat(callback : @escaping (Elanat) -> Void){
        let url = URL(string: baseURL + elanatURL)!
        
        let params = self.baseParams
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    if let i = value.Data.dictionaryObject{
                        if let a = Elanat(JSON: i){
                            callback(a)
                        }
                    }
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }
    
    func takeElanRegistered(Elan : String,callback : @escaping (Bool) -> Void){
        let url = URL(string: baseURL + takeElanRegisteredURL)!
        
        var params = self.baseParams
        params["Elan"] = Elan
        params["Customer"] = User.getID()
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(true)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }
    
    
    func takeElanUnRegistered(Elan : String,Name : String,Email : String,Tel : String, callback : @escaping (Bool) -> Void){
        let url = URL(string: baseURL + takeElanUnRegisteredURL)!
        
        var params = self.baseParams
        params["Elan"] = Elan
        params["Name"] = Name
        params["Email"] = Email
        params["Tel"] = Tel
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    callback(true)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }
    
    func billRegistered(Products : [String], QTYs : [Int],Colors : [Int],Currency : String,Private : String! = nil, Public : String! = nil, Customer : String, callback : @escaping (String) -> Void){

        let url = URL(string: baseURL + billRegisteredURL)!

        var params = self.baseParams
        
        if let arr = JSON(Products).rawString(){
            params["Products"] = arr
        }
        if let arr = JSON(QTYs).rawString(){
            params["QTYs"] = arr
        }
        
        params["Currency"] = Currency
        params["Customer"] = Customer
        
        if let pr = Private{
            params["Private"] = pr
        }
        if let pu = Private{
            params["Public"] = pu
        }
        
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Data"]["FinalBill"].stringValue)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }
    
    
    func bill(Products : [String], QTYs : [Int],Colors : [Int], Currency : String,callback : @escaping (String) -> Void){

        let url = URL(string: baseURL + billURL)!

        var params = self.baseParams
        if let arr = JSON(Products).rawString(){
            params["Products"] = arr
        }
        if let arr = JSON(QTYs).rawString(){
            params["QTYs"] = arr
        }
        params["Currency"] = Currency
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Data"].stringValue)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }


    
    func contactUs(Name : String,Email : String,Message : String,callback : @escaping (String) -> Void){
        let url = URL(string: "\(baseURL)\(contactUsURL)")!
        
        var params = self.baseParams
        params["Name"] = Name
        params["Email"] = Email
        params["Message"] = Message
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Data"].stringValue)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    
    
    func addElan(Title : String,
                 Content : String,
                 StartAt : String,
                 NumberOfDays : String,
                 Name : String,
                 Tel : String,
                 Mobile : String,
                 Email : String,
                 Type : String,
                 PixelSize : String,
                 ImageURL : String,
                 
                 callback : @escaping (String) -> Void){
        
        let url = URL(string: "\(baseURL)\(addElanURL)")!
        
        var params = self.baseParams
        params["Title"] = Title
        params["Content"] = Content
        params["StartAt"] = StartAt
        params["NumberOfDays"] = NumberOfDays
        params["Name"] = Name
        params["Tel"] = Tel
        params["Mobile"] = Mobile
        params["Email"] = Email
        params["Type"] = Type
        params["PixelSize"] = PixelSize
        params["ImageURL"] = ImageURL
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Data"].stringValue)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }


    func promotion(callback : @escaping ([Promotion]) -> Void){
        let url = URL(string: "\(baseURL)\(promotionURL)")!
        
        var params = self.baseParams
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [Promotion]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = Promotion(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
            }
        }
    }

    
    func takePromotion(Promotion : String, callback : @escaping (Bool) -> Void){
        let url = URL(string: "\(baseURL)\(takePromotionURL)")!
        
        var params = self.baseParams
        params["Customer"] = User.getID()
        params["Promotion"] = Promotion
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Status"].Boolean)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func changePassword(OldPassword : String,NewPassword : String, callback : @escaping (Bool) -> Void){
        let url = URL(string: "\(baseURL)\(changePasswordURL)")!
        
        var params = self.baseParams
        params["Customer"] = User.getID()
        params["Email"] = User.getCurrentUser().Email
        params["OldPassword"] = OldPassword
        params["NewPassword"] = NewPassword
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Status"].Boolean)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }

    func myAddresses(callback : @escaping ([Address]) -> Void){
        let url = URL(string: "\(baseURL)\(myAddressesURL)")!
        
        var params = self.baseParams
        params["Customer"] = User.getID()
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [Address]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = Address(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func shippingCompany(callback : @escaping ([ShippingCompany]) -> Void){
        let url = URL(string: "\(baseURL)\(shippingCompanyURL)")!
        
        var params = self.baseParams
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [ShippingCompany]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = ShippingCompany(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func place(callback : @escaping ([Place]) -> Void){
        let url = URL(string: "\(baseURL)\(placeURL)")!
        
        var params = self.baseParams
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [Place]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = Place(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }


    func order(Address : String,
               Products : [String],
               QTYs : [Int],
               Colors : [Int],
               StoreCredit : String,
               ShippingCompany : String,
               Public : String! = nil,
               Private : String! = nil,
               Lat : Double! = nil,
               Lon : Double! = nil,
               Region : String,
               Currency : String,
               
               callback : @escaping (String) -> Void){
        let url = URL(string: "\(baseURL)\(orderURL)")!
        
        
        
        var params = self.baseParams
        params["Address"] = Address
        params["Customer"] = User.getID()
        params["StoreCredit"] = StoreCredit
        params["ShippingCompany"] = ShippingCompany
        params["Region"] = Region
        params["Currency"] = Currency
        
        if let v = Public{
            params["Public"] = v
        }
        if let v = Private{
            params["Private"] = v
        }
        if let v = Lat{
            params["Lat"] = v
        }
        if let v = Lon{
            params["Lon"] = v
        }
        
        
        if let arr = JSON(Products).rawString(){
            params["Products"] = arr
        }
        if let arr = JSON(QTYs).rawString(){
            params["QTYs"] = arr
        }
        var colors = [String]()
        for _ in Products{
            colors.append("0")
        }
        if let arr = JSON(colors).rawString(){
            params["Colors"] = arr
        }
        
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Data"]["url"].stringValue)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func orderNotRegistered(Address : String,
               Products : [String],
               QTYs : [Int],
               Colors : [Int],
               StoreCredit : String,
               ShippingCompany : String,
               Public : String! = nil,
               Private : String! = nil,
               Lat : Double! = nil,
               Lon : Double! = nil,
               Region : String,
               Currency : String,
               Name : String,
               Phone : String,
               Mobile : String,
               Email : String,
               callback : @escaping (String) -> Void){
        let url = URL(string: "\(baseURL)\(orderNotRegisteredURL)")!
        
        var params = self.baseParams
        params["Address"] = Address
        params["Customer"] = User.getID()
        params["StoreCredit"] = StoreCredit
        params["ShippingCompany"] = ShippingCompany
        params["Region"] = Region
        params["Currency"] = Currency
        
        params["Name"] = Name
        params["Phone"] = Phone
        params["Mobile"] = Mobile
        params["Email"] = Email
        
        if let v = Public{
            params["Public"] = v
        }
        if let v = Private{
            params["Private"] = v
        }
        if let v = Lat{
            params["Lat"] = v
        }
        if let v = Lon{
            params["Lon"] = v
        }
        
        if let arr = JSON(Products).rawString(){
            params["Products"] = arr
        }
        if let arr = JSON(QTYs).rawString(){
            params["QTYs"] = arr
        }
        var colors = [String]()
        for _ in Products{
            colors.append("0")
        }
        if let arr = JSON(colors).rawString(){
            params["Colors"] = arr
        }
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    callback(value.Data["Data"]["url"].stringValue)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }

    
    func getOrders(callback : @escaping ([Order]) -> Void){
        let url = URL(string: "\(baseURL)\(ordersURL)")!
        
        var params = self.baseParams
        params["Customer"] = User.getID()
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [Order]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = Order(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                    
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
                
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func track(OrderNumber : String, callback : @escaping ([TrackItem]) -> Void){
        let url = URL(string: "\(baseURL)\(trackURL)")!
        
        var params = self.baseParams
        params["OrderNumber"] = OrderNumber
//        params["AWBNumber"] = AWBNumber
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [TrackItem]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = TrackItem(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }


    func currency(_ callback : @escaping ([Currency]) -> Void){
        let url = URL(string: "\(baseURL)\(currencyURL)")!
        
        let params = self.baseParams
        
        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [Currency]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = Currency(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func getLang(_ callback : @escaping ([Lang]) -> Void){
        let url = URL(string: "\(baseURL)\(langURL)")!
        
        var params = self.baseParams
        params["Type"] = "1"

        Alamofire.request(url, method: .post, parameters: params, encoding: encodingBody, headers: nil).responseObject { (response : DataResponse<CustomResponse>) in
            
            self.output(response)
            
            
            switch response.result{
            case .success(let value):
                
                if value.status {
                    
                    var res = [Lang]()
                    
                    for i in value.Data["Data"].arrayValue{
                        let a = Lang(JSON: i.dictionaryObject!)!
                        res.append(a)
                    }
                    
                    callback(res)
                }
                else{
                    notific.post(name:_RequestErrorNotificationReceived.not, object: value)
                }
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }
    
    func getLangFile(lang : Lang, callback : @escaping (Bool) -> Void){
        let url = URL(string: lang.File)!
        
//        Alamofire.SessionManager.default.requestWithoutCache("https://google.com/").response { response in
        
        Alamofire.SessionManager.default.requestWithoutCache(url, method: .get, parameters: nil, encoding: encodingQuery, headers: nil).responseData { (response) in
            
//            self.output(response)
            
            if let d = response.data{
                print(NSString.init(data: d, encoding: String.Encoding.utf8.rawValue))
            }
            switch response.result{
            case .success(let value):
                print(JSON.init(value))
                
                Local.setCurrent(value,lang: lang)
                callback(true)
            case .failure(let error):
                notific.post(name: _ConnectionErrorNotification.not, object: error)
                break
            }
        }
    }





    
    func output(_ res : DataResponse<CustomResponse>){
        if let urlString = res.request?.url?.absoluteString{
            print(urlString)
        }
        if let bod = res.request?.httpBody, let body = NSString(data: bod, encoding: String.Encoding.utf8.rawValue){
            print(body)
        }
        
        if let h = res.request?.allHTTPHeaderFields{
            print(h)
        }
        
        if let s = NSString(data: res.data!, encoding: String.Encoding.utf8.rawValue){
            print(s)
        }
    }
    
    
    private func getHearders() -> [String : String]{
        let headers :  [String : String] = ["os":"ios"]
        return headers
    }
    
}







extension Alamofire.SessionManager{
    @discardableResult
    open func requestWithoutCache(
        _ url: URLConvertible,
        method: HTTPMethod = .get,
        parameters: Parameters? = nil,
        encoding: ParameterEncoding = URLEncoding.default,
        headers: HTTPHeaders? = nil)// also you can add URLRequest.CachePolicy here as parameter
        -> DataRequest
    {
        do {
            var urlRequest = try URLRequest(url: url, method: method, headers: headers)
            urlRequest.cachePolicy = .reloadIgnoringCacheData // <<== Cache disabled
            let encodedURLRequest = try encoding.encode(urlRequest, with: parameters)
            return request(encodedURLRequest)
        } catch {
            // TODO: find a better way to handle error
            print(error)
            return request(URLRequest(url: URL(string: "http://example.com/wrong_request")!))
        }
    }
}
