//
//  CustomResponse.swift
//  We1l
//
//  Created by Yahya Tabba on 2/9/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import Foundation
import SwiftyJSON
import ObjectMapper
import AlamofireObjectMapper
import Alamofire



class CustomResponse : BaseEntity {
    
    var ErrorCode : Int = 0
    var Data : JSON!
    var ErrorMessage : String = ""
    var Count : Int = 0
    
    
    var description : String{
        return "CustomResponse: { ErrorCode: \(ErrorCode), Data: \(Data!) , ErrorMessage : \(ErrorMessage) }"
    }
    
    
    var status : Bool {
        return (self.ErrorCode == 0)
    }
    
    var message : String{
        return self.ErrorMessage
    }
    
    override func mapping(map: Map) {
        Count <- map["Count"]
        ErrorCode <- map["ErrorCode"]
        Data <- map["Data"]
        ErrorMessage <- map["ErrorMessage"]
    }
    
    
}
