//
//  Provider.swift
//  We1l
//
//  Created by Yahya Tabba on 2/9/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import Foundation
import SDWebImage
import MapKit
import CoreLocation



class Provider{
    
    static var tabBar : TabBarVC?
    static var Cart = [CartItem]()
    static var currentLocation = LocationInfo()
    
    static var locationManager = CLLocationManager()

    
    static func sd_setImage(_ img : UIImageView, urlString : String!, placeholderImage : UIImage! = nil, callback : SDExternalCompletionBlock? = nil){
        
        if let u = urlString,
            //            let us = u.addingPercentEncoding(withAllowedCharacters: CharacterSet.urlPathAllowed),
            let url = URL.init(string: u){
            
            img.sd_setShowActivityIndicatorView(true)
            img.sd_setIndicatorStyle(.gray)
            
            img.sd_setImage(with: url, placeholderImage: placeholderImage, options: .refreshCached, completed: callback)
            
        }else{
            img.image = placeholderImage
        }
    }
    
    static func startUpdatingLocation() {
        locationManager = CLLocationManager()
        locationManager.requestAlwaysAuthorization()
        
        DispatchQueue.main.async {
            locationManager.startUpdatingLocation()
        }
    }
    
    static func stopUpdatingLocation() {
        locationManager.stopUpdatingLocation()
    }
    
    static func isLocationPermissionGranted() -> Bool
    {
        //        if Provider.shared.locationManager.location != nil{
        //            return true
        //        }
        guard CLLocationManager.locationServicesEnabled() else { return false }
        
        return [.authorizedAlways, .authorizedWhenInUse].contains(CLLocationManager.authorizationStatus())
    }
    
    
}
