//
//  CategoriesCell.swift
//  We1l
//
//  Created by Yahya Tabba on 2/11/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit

class CategoriesCell: UITableViewCell,UICollectionViewDelegate,UICollectionViewDataSource,UICollectionViewDelegateFlowLayout {

    @IBOutlet weak var lbl : UILabel!
    @IBOutlet weak var collectionView : UICollectionView!
    var parentVC : CategoriesBaseVC?
    
    var cat : CategoryObj!{
        didSet{
            self.lbl.text = cat.Name
            collectionView.reloadData()
        }
    }
    
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return cat.categories.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "CategoryCell2", for: indexPath) as! CategoryCell
        cell.category = self.cat.categories[indexPath.row]
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        let w = collectionView.frame.width
        let h = collectionView.frame.height
        return (indexPath.row == 0) ? CGSize(width: w / 2, height: h) : CGSize(width: w / 2, height: h / 2)
    }
    
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        let main = UIStoryboard.init(name: "Main", bundle: nil)
        let vc = main.instantiateViewController(withIdentifier: "CategoriesVC") as! CategoriesVC
        vc.baseCategory = self.cat.categories[indexPath.row]
        self.parentVC?.navigationController?.pushViewController(vc, animated: true)

    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
        collectionView.delegate = self
        collectionView.dataSource = self
        collectionView.register(UINib.init(nibName: "CategoryCell2", bundle: nil), forCellWithReuseIdentifier: "CategoryCell2")
        collectionView.contentInset = UIEdgeInsets(top: 0, left: 20, bottom: 0, right: 0)
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}
